/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.entity;

import com.dangdang.ddframe.job.api.JobType;
import io.polaris.core.jdbc.annotation.Column;
import io.polaris.core.jdbc.annotation.Id;
import io.polaris.core.jdbc.annotation.Table;
import io.polaris.framework.toolkit.elasticjob.err.JobException;
import io.polaris.validation.group.Create;
import io.polaris.validation.group.Delete;
import io.polaris.validation.group.Retrieve;
import io.polaris.validation.group.Update;
import io.polaris.validation.group.UpdateEntire;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;

@Table(value="CRM_JOB_CFG")
public class JobCfgEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE = "CRM_JOB_CFG";
    @Schema(description="ID")
    @Id
    @Column(value="ID")
    @NotNull(groups={Create.class, Update.class, Delete.class, Retrieve.class, UpdateEntire.class}, message="ID[id]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, Update.class, Delete.class, Retrieve.class, UpdateEntire.class}, message="ID[id]\u4e0d\u80fd\u4e3a\u7a7a") String id;
    @Schema(description="\u73af\u5883")
    @Column(value="PROFILE")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u73af\u5883[profile]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u73af\u5883[profile]\u4e0d\u80fd\u4e3a\u7a7a") String profile;
    @Schema(description="\u5e94\u7528\u6807\u8bc6")
    @Column(value="SYS_ID")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u5e94\u7528\u6807\u8bc6[sysId]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u5e94\u7528\u6807\u8bc6[sysId]\u4e0d\u80fd\u4e3a\u7a7a") String sysId;
    @Schema(description="\u4f5c\u4e1a\u4efb\u52a1\u540d")
    @Column(value="JOB_NAME")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u4efb\u52a1\u540d[jobName]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u4efb\u52a1\u540d[jobName]\u4e0d\u80fd\u4e3a\u7a7a") String jobName;
    @Schema(description="\u4f5c\u4e1a\u7c7b\u578b")
    @Column(value="JOB_TYPE")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u7c7b\u578b[jobType]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u7c7b\u578b[jobType]\u4e0d\u80fd\u4e3a\u7a7a") JobType jobType;
    @Schema(description="DESCRIPTION")
    @Column(value="DESCRIPTION")
    private String description;
    @Schema(description="\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570")
    @Column(value="JOB_PARAMETER")
    private String jobParameter;
    @Schema(description="\u4f5c\u4e1a\u6267\u884c\u5668")
    @Column(value="JOB_EXECUTOR")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u6267\u884c\u5668[jobExecutor]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u6267\u884c\u5668[jobExecutor]\u4e0d\u80fd\u4e3a\u7a7a") String jobExecutor;
    @Schema(description="\u4f5c\u4e1a\u542f\u52a8\u65f6\u95f4\u7684cron\u8868\u8fbe\u5f0f")
    @Column(value="JOB_CRON")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u542f\u52a8\u65f6\u95f4\u7684cron\u8868\u8fbe\u5f0f[jobCron]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u542f\u52a8\u65f6\u95f4\u7684cron\u8868\u8fbe\u5f0f[jobCron]\u4e0d\u80fd\u4e3a\u7a7a") String jobCron;
    @Schema(description="\u662f\u5426\u542f\u52a8\u5206\u7247\u4f5c\u4e1a")
    @Column(value="SHARDING_ENABLED")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u542f\u52a8\u5206\u7247\u4f5c\u4e1a[shardingEnabled]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u542f\u52a8\u5206\u7247\u4f5c\u4e1a[shardingEnabled]\u4e0d\u80fd\u4e3a\u7a7a") Boolean shardingEnabled = true;
    @Schema(description="\u4f5c\u4e1a\u5206\u7247\u603b\u6570")
    @Column(value="SHARDING_TOTAL_COUNT")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u5206\u7247\u603b\u6570[shardingTotalCount]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u5206\u7247\u603b\u6570[shardingTotalCount]\u4e0d\u80fd\u4e3a\u7a7a") Integer shardingTotalCount;
    @Schema(description="\u5206\u7247\u5e8f\u5217\u53f7\u548c\u4e2a\u6027\u5316\u53c2\u6570\u5bf9\u7167\u8868")
    @Column(value="SHARDING_ITEM_PARAMETERS")
    private String shardingItemParameters;
    @Schema(description="\u662f\u5426\u5f00\u542f\u5931\u6548\u8f6c\u79fb")
    @Column(value="FAILOVER")
    private Boolean failover;
    @Schema(description="\u662f\u5426\u5f00\u542f\u9519\u8fc7\u4f5c\u4e1a\u91cd\u65b0\u6267\u884c")
    @Column(value="MISFIRE")
    private Boolean misfire;
    @Schema(description="\u662f\u5426\u6d41\u5f0f\u5904\u7406\u6570\u636e")
    @Column(value="STREAMING_PROCESS")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u6d41\u5f0f\u5904\u7406\u6570\u636e[streamingProcess]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u6d41\u5f0f\u5904\u7406\u6570\u636e[streamingProcess]\u4e0d\u80fd\u4e3a\u7a7a") Boolean streamingProcess;
    @Schema(description="\u76d1\u63a7\u4f5c\u4e1a\u6267\u884c\u65f6\u72b6\u6001")
    @Column(value="MONITOR_EXECUTION")
    private Boolean monitorExecution;
    @Schema(description="\u6700\u5927\u5bb9\u5fcd\u7684\u672c\u673a\u4e0e\u6ce8\u518c\u4e2d\u5fc3\u7684\u65f6\u95f4\u8bef\u5dee\u79d2\u6570")
    @Column(value="MAX_TIME_DIFF_SECONDS")
    private Integer maxTimeDiffSeconds;
    @Schema(description="\u4f5c\u4e1a\u8f85\u52a9\u76d1\u63a7\u7aef\u53e3")
    @Column(value="MONITOR_PORT")
    private Integer monitorPort;
    @Schema(description="\u4f5c\u4e1a\u5206\u7247\u7b56\u7565\u5b9e\u73b0\u7c7b\u5168\u8def\u5f84")
    @Column(value="JOB_SHARDING_STRATEGY")
    private String jobShardingStrategy;
    @Schema(description="\u4f5c\u4e1a\u662f\u5426\u542f\u52a8\u65f6\u7981\u6b62")
    @Column(value="DISABLED")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u662f\u5426\u542f\u52a8\u65f6\u7981\u6b62[disabled]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u662f\u5426\u542f\u52a8\u65f6\u7981\u6b62[disabled]\u4e0d\u80fd\u4e3a\u7a7a") Boolean disabled;
    @Schema(description="\u672c\u5730\u914d\u7f6e\u662f\u5426\u53ef\u8986\u76d6\u6ce8\u518c\u4e2d\u5fc3\u914d\u7f6e")
    @Column(value="OVERWRITE")
    private Boolean overwrite;
    @Schema(description="\u4fee\u590d\u4f5c\u4e1a\u670d\u52a1\u5668\u4e0d\u4e00\u81f4\u72b6\u6001\u670d\u52a1\u6267\u884c\u95f4\u9694\u5206\u949f\u6570")
    @Column(value="RECONCILE_INTERVAL_MINUTES")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4fee\u590d\u4f5c\u4e1a\u670d\u52a1\u5668\u4e0d\u4e00\u81f4\u72b6\u6001\u670d\u52a1\u6267\u884c\u95f4\u9694\u5206\u949f\u6570[reconcileIntervalMinutes]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4fee\u590d\u4f5c\u4e1a\u670d\u52a1\u5668\u4e0d\u4e00\u81f4\u72b6\u6001\u670d\u52a1\u6267\u884c\u95f4\u9694\u5206\u949f\u6570[reconcileIntervalMinutes]\u4e0d\u80fd\u4e3a\u7a7a") Integer reconcileIntervalMinutes;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027")
    @Column(value="JOB_ATTRS")
    private String jobAttrs;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027-\u4f5c\u4e1a\u5f02\u5e38\u5904\u7406\u5668")
    @Column(value="JOB_EXCEPTION_HANDLER")
    private String jobExceptionHandler;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027-\u7ebf\u7a0b\u6c60\u670d\u52a1\u5904\u7406\u5668")
    @Column(value="EXECUTOR_SERVICE_HANDLER")
    private String executorServiceHandler;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027-\u91c7\u7528\u52a8\u6001\u7ebf\u7a0b\u6c60\u670d\u52a1\u5904\u7406\u5668\u7684\u671f\u671b\u7ebf\u7a0b\u6c60\u5927\u5c0f")
    @Column(value="EXECUTOR_POOL_SIZE")
    private Long executorPoolSize;
    @Schema(description="\u662f\u5426\u5220\u9664")
    @Column(value="DELETED")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u5220\u9664[deleted]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u5220\u9664[deleted]\u4e0d\u80fd\u4e3a\u7a7a") Boolean deleted;
    @Schema(description="\u521b\u5efa\u7528\u6237")
    @Column(value="CRT_USER", updatable=false)
    private Long crtUser;
    @Schema(description="\u521b\u5efa\u7528\u6237")
    @Column(value="CRT_USER_NAME", updatable=false)
    private String crtUserName;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @Column(value="CRT_DT", updatable=false, createTime=true)
    private Date crtDt;
    @Schema(description="\u66f4\u65b0\u7528\u6237")
    @Column(value="UPT_USER")
    private Long uptUser;
    @Schema(description="\u66f4\u65b0\u7528\u6237")
    @Column(value="UPT_USER_NAME")
    private String uptUserName;
    @Schema(description="\u66f4\u65b0\u65f6\u95f4")
    @Column(value="UPT_DT", updateTime=true)
    private Date uptDt;
    @Column(ignored=true)
    private Class<?> jobExecutorClass;

    public Class<?> getJobExecutorClass() {
        if (this.jobExecutorClass == null) {
            if (this.jobExecutor == null) {
                return null;
            }
            try {
                this.jobExecutorClass = Class.forName(this.jobExecutor);
            }
            catch (ClassNotFoundException e) {
                throw new JobException("\u4f5c\u4e1a\u6267\u884c\u5668\u7c7b\u4e0d\u5b58\u5728" + this.jobExecutor, e);
            }
        }
        return this.jobExecutorClass;
    }

    public void setJobExecutorClass(Class<?> jobExecutorClass) {
        this.jobExecutorClass = jobExecutorClass;
        this.jobExecutor = jobExecutorClass.getName();
    }

    private static String $default$description() {
        return "";
    }

    private static String $default$jobParameter() {
        return "";
    }

    private static String $default$shardingItemParameters() {
        return "";
    }

    private static Boolean $default$failover() {
        return false;
    }

    private static Boolean $default$misfire() {
        return true;
    }

    private static Boolean $default$streamingProcess() {
        return true;
    }

    private static Boolean $default$monitorExecution() {
        return true;
    }

    private static Integer $default$maxTimeDiffSeconds() {
        return -1;
    }

    private static Integer $default$monitorPort() {
        return -1;
    }

    private static String $default$jobShardingStrategy() {
        return "";
    }

    private static Integer $default$reconcileIntervalMinutes() {
        return 10;
    }

    public static JobCfgEntityBuilder builder() {
        return new JobCfgEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getSysId() {
        return this.sysId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobParameter() {
        return this.jobParameter;
    }

    public String getJobExecutor() {
        return this.jobExecutor;
    }

    public String getJobCron() {
        return this.jobCron;
    }

    public Boolean getShardingEnabled() {
        return this.shardingEnabled;
    }

    public Integer getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    public String getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    public Boolean getFailover() {
        return this.failover;
    }

    public Boolean getMisfire() {
        return this.misfire;
    }

    public Boolean getStreamingProcess() {
        return this.streamingProcess;
    }

    public Boolean getMonitorExecution() {
        return this.monitorExecution;
    }

    public Integer getMaxTimeDiffSeconds() {
        return this.maxTimeDiffSeconds;
    }

    public Integer getMonitorPort() {
        return this.monitorPort;
    }

    public String getJobShardingStrategy() {
        return this.jobShardingStrategy;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public Integer getReconcileIntervalMinutes() {
        return this.reconcileIntervalMinutes;
    }

    public String getJobAttrs() {
        return this.jobAttrs;
    }

    public String getJobExceptionHandler() {
        return this.jobExceptionHandler;
    }

    public String getExecutorServiceHandler() {
        return this.executorServiceHandler;
    }

    public Long getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Long getCrtUser() {
        return this.crtUser;
    }

    public String getCrtUserName() {
        return this.crtUserName;
    }

    public Date getCrtDt() {
        return this.crtDt;
    }

    public Long getUptUser() {
        return this.uptUser;
    }

    public String getUptUserName() {
        return this.uptUserName;
    }

    public Date getUptDt() {
        return this.uptDt;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJobParameter(String jobParameter) {
        this.jobParameter = jobParameter;
    }

    public void setJobExecutor(String jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setJobCron(String jobCron) {
        this.jobCron = jobCron;
    }

    public void setShardingEnabled(Boolean shardingEnabled) {
        this.shardingEnabled = shardingEnabled;
    }

    public void setShardingTotalCount(Integer shardingTotalCount) {
        this.shardingTotalCount = shardingTotalCount;
    }

    public void setShardingItemParameters(String shardingItemParameters) {
        this.shardingItemParameters = shardingItemParameters;
    }

    public void setFailover(Boolean failover) {
        this.failover = failover;
    }

    public void setMisfire(Boolean misfire) {
        this.misfire = misfire;
    }

    public void setStreamingProcess(Boolean streamingProcess) {
        this.streamingProcess = streamingProcess;
    }

    public void setMonitorExecution(Boolean monitorExecution) {
        this.monitorExecution = monitorExecution;
    }

    public void setMaxTimeDiffSeconds(Integer maxTimeDiffSeconds) {
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
    }

    public void setMonitorPort(Integer monitorPort) {
        this.monitorPort = monitorPort;
    }

    public void setJobShardingStrategy(String jobShardingStrategy) {
        this.jobShardingStrategy = jobShardingStrategy;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setReconcileIntervalMinutes(Integer reconcileIntervalMinutes) {
        this.reconcileIntervalMinutes = reconcileIntervalMinutes;
    }

    public void setJobAttrs(String jobAttrs) {
        this.jobAttrs = jobAttrs;
    }

    public void setJobExceptionHandler(String jobExceptionHandler) {
        this.jobExceptionHandler = jobExceptionHandler;
    }

    public void setExecutorServiceHandler(String executorServiceHandler) {
        this.executorServiceHandler = executorServiceHandler;
    }

    public void setExecutorPoolSize(Long executorPoolSize) {
        this.executorPoolSize = executorPoolSize;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setCrtUser(Long crtUser) {
        this.crtUser = crtUser;
    }

    public void setCrtUserName(String crtUserName) {
        this.crtUserName = crtUserName;
    }

    public void setCrtDt(Date crtDt) {
        this.crtDt = crtDt;
    }

    public void setUptUser(Long uptUser) {
        this.uptUser = uptUser;
    }

    public void setUptUserName(String uptUserName) {
        this.uptUserName = uptUserName;
    }

    public void setUptDt(Date uptDt) {
        this.uptDt = uptDt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobCfgEntity)) {
            return false;
        }
        JobCfgEntity other = (JobCfgEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$shardingEnabled = this.shardingEnabled;
        Boolean other$shardingEnabled = other.shardingEnabled;
        if (this$shardingEnabled == null ? other$shardingEnabled != null : !((Object)this$shardingEnabled).equals(other$shardingEnabled)) {
            return false;
        }
        Integer this$shardingTotalCount = this.shardingTotalCount;
        Integer other$shardingTotalCount = other.shardingTotalCount;
        if (this$shardingTotalCount == null ? other$shardingTotalCount != null : !((Object)this$shardingTotalCount).equals(other$shardingTotalCount)) {
            return false;
        }
        Boolean this$failover = this.failover;
        Boolean other$failover = other.failover;
        if (this$failover == null ? other$failover != null : !((Object)this$failover).equals(other$failover)) {
            return false;
        }
        Boolean this$misfire = this.misfire;
        Boolean other$misfire = other.misfire;
        if (this$misfire == null ? other$misfire != null : !((Object)this$misfire).equals(other$misfire)) {
            return false;
        }
        Boolean this$streamingProcess = this.streamingProcess;
        Boolean other$streamingProcess = other.streamingProcess;
        if (this$streamingProcess == null ? other$streamingProcess != null : !((Object)this$streamingProcess).equals(other$streamingProcess)) {
            return false;
        }
        Boolean this$monitorExecution = this.monitorExecution;
        Boolean other$monitorExecution = other.monitorExecution;
        if (this$monitorExecution == null ? other$monitorExecution != null : !((Object)this$monitorExecution).equals(other$monitorExecution)) {
            return false;
        }
        Integer this$maxTimeDiffSeconds = this.maxTimeDiffSeconds;
        Integer other$maxTimeDiffSeconds = other.maxTimeDiffSeconds;
        if (this$maxTimeDiffSeconds == null ? other$maxTimeDiffSeconds != null : !((Object)this$maxTimeDiffSeconds).equals(other$maxTimeDiffSeconds)) {
            return false;
        }
        Integer this$monitorPort = this.monitorPort;
        Integer other$monitorPort = other.monitorPort;
        if (this$monitorPort == null ? other$monitorPort != null : !((Object)this$monitorPort).equals(other$monitorPort)) {
            return false;
        }
        Boolean this$disabled = this.disabled;
        Boolean other$disabled = other.disabled;
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Boolean this$overwrite = this.overwrite;
        Boolean other$overwrite = other.overwrite;
        if (this$overwrite == null ? other$overwrite != null : !((Object)this$overwrite).equals(other$overwrite)) {
            return false;
        }
        Integer this$reconcileIntervalMinutes = this.reconcileIntervalMinutes;
        Integer other$reconcileIntervalMinutes = other.reconcileIntervalMinutes;
        if (this$reconcileIntervalMinutes == null ? other$reconcileIntervalMinutes != null : !((Object)this$reconcileIntervalMinutes).equals(other$reconcileIntervalMinutes)) {
            return false;
        }
        Long this$executorPoolSize = this.executorPoolSize;
        Long other$executorPoolSize = other.executorPoolSize;
        if (this$executorPoolSize == null ? other$executorPoolSize != null : !((Object)this$executorPoolSize).equals(other$executorPoolSize)) {
            return false;
        }
        Boolean this$deleted = this.deleted;
        Boolean other$deleted = other.deleted;
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Long this$crtUser = this.crtUser;
        Long other$crtUser = other.crtUser;
        if (this$crtUser == null ? other$crtUser != null : !((Object)this$crtUser).equals(other$crtUser)) {
            return false;
        }
        Long this$uptUser = this.uptUser;
        Long other$uptUser = other.uptUser;
        if (this$uptUser == null ? other$uptUser != null : !((Object)this$uptUser).equals(other$uptUser)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$profile = this.profile;
        String other$profile = other.profile;
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        String this$sysId = this.sysId;
        String other$sysId = other.sysId;
        if (this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId)) {
            return false;
        }
        String this$jobName = this.jobName;
        String other$jobName = other.jobName;
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        JobType this$jobType = this.jobType;
        JobType other$jobType = other.jobType;
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$jobParameter = this.jobParameter;
        String other$jobParameter = other.jobParameter;
        if (this$jobParameter == null ? other$jobParameter != null : !this$jobParameter.equals(other$jobParameter)) {
            return false;
        }
        String this$jobExecutor = this.jobExecutor;
        String other$jobExecutor = other.jobExecutor;
        if (this$jobExecutor == null ? other$jobExecutor != null : !this$jobExecutor.equals(other$jobExecutor)) {
            return false;
        }
        String this$jobCron = this.jobCron;
        String other$jobCron = other.jobCron;
        if (this$jobCron == null ? other$jobCron != null : !this$jobCron.equals(other$jobCron)) {
            return false;
        }
        String this$shardingItemParameters = this.shardingItemParameters;
        String other$shardingItemParameters = other.shardingItemParameters;
        if (this$shardingItemParameters == null ? other$shardingItemParameters != null : !this$shardingItemParameters.equals(other$shardingItemParameters)) {
            return false;
        }
        String this$jobShardingStrategy = this.jobShardingStrategy;
        String other$jobShardingStrategy = other.jobShardingStrategy;
        if (this$jobShardingStrategy == null ? other$jobShardingStrategy != null : !this$jobShardingStrategy.equals(other$jobShardingStrategy)) {
            return false;
        }
        String this$jobAttrs = this.jobAttrs;
        String other$jobAttrs = other.jobAttrs;
        if (this$jobAttrs == null ? other$jobAttrs != null : !this$jobAttrs.equals(other$jobAttrs)) {
            return false;
        }
        String this$jobExceptionHandler = this.jobExceptionHandler;
        String other$jobExceptionHandler = other.jobExceptionHandler;
        if (this$jobExceptionHandler == null ? other$jobExceptionHandler != null : !this$jobExceptionHandler.equals(other$jobExceptionHandler)) {
            return false;
        }
        String this$executorServiceHandler = this.executorServiceHandler;
        String other$executorServiceHandler = other.executorServiceHandler;
        if (this$executorServiceHandler == null ? other$executorServiceHandler != null : !this$executorServiceHandler.equals(other$executorServiceHandler)) {
            return false;
        }
        String this$crtUserName = this.crtUserName;
        String other$crtUserName = other.crtUserName;
        if (this$crtUserName == null ? other$crtUserName != null : !this$crtUserName.equals(other$crtUserName)) {
            return false;
        }
        Date this$crtDt = this.crtDt;
        Date other$crtDt = other.crtDt;
        if (this$crtDt == null ? other$crtDt != null : !((Object)this$crtDt).equals(other$crtDt)) {
            return false;
        }
        String this$uptUserName = this.uptUserName;
        String other$uptUserName = other.uptUserName;
        if (this$uptUserName == null ? other$uptUserName != null : !this$uptUserName.equals(other$uptUserName)) {
            return false;
        }
        Date this$uptDt = this.uptDt;
        Date other$uptDt = other.uptDt;
        if (this$uptDt == null ? other$uptDt != null : !((Object)this$uptDt).equals(other$uptDt)) {
            return false;
        }
        Class<?> this$jobExecutorClass = this.jobExecutorClass;
        Class<?> other$jobExecutorClass = other.jobExecutorClass;
        return !(this$jobExecutorClass == null ? other$jobExecutorClass != null : !this$jobExecutorClass.equals(other$jobExecutorClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobCfgEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $shardingEnabled = this.shardingEnabled;
        result = result * 59 + ($shardingEnabled == null ? 43 : ((Object)$shardingEnabled).hashCode());
        Integer $shardingTotalCount = this.shardingTotalCount;
        result = result * 59 + ($shardingTotalCount == null ? 43 : ((Object)$shardingTotalCount).hashCode());
        Boolean $failover = this.failover;
        result = result * 59 + ($failover == null ? 43 : ((Object)$failover).hashCode());
        Boolean $misfire = this.misfire;
        result = result * 59 + ($misfire == null ? 43 : ((Object)$misfire).hashCode());
        Boolean $streamingProcess = this.streamingProcess;
        result = result * 59 + ($streamingProcess == null ? 43 : ((Object)$streamingProcess).hashCode());
        Boolean $monitorExecution = this.monitorExecution;
        result = result * 59 + ($monitorExecution == null ? 43 : ((Object)$monitorExecution).hashCode());
        Integer $maxTimeDiffSeconds = this.maxTimeDiffSeconds;
        result = result * 59 + ($maxTimeDiffSeconds == null ? 43 : ((Object)$maxTimeDiffSeconds).hashCode());
        Integer $monitorPort = this.monitorPort;
        result = result * 59 + ($monitorPort == null ? 43 : ((Object)$monitorPort).hashCode());
        Boolean $disabled = this.disabled;
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Boolean $overwrite = this.overwrite;
        result = result * 59 + ($overwrite == null ? 43 : ((Object)$overwrite).hashCode());
        Integer $reconcileIntervalMinutes = this.reconcileIntervalMinutes;
        result = result * 59 + ($reconcileIntervalMinutes == null ? 43 : ((Object)$reconcileIntervalMinutes).hashCode());
        Long $executorPoolSize = this.executorPoolSize;
        result = result * 59 + ($executorPoolSize == null ? 43 : ((Object)$executorPoolSize).hashCode());
        Boolean $deleted = this.deleted;
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Long $crtUser = this.crtUser;
        result = result * 59 + ($crtUser == null ? 43 : ((Object)$crtUser).hashCode());
        Long $uptUser = this.uptUser;
        result = result * 59 + ($uptUser == null ? 43 : ((Object)$uptUser).hashCode());
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $profile = this.profile;
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        String $sysId = this.sysId;
        result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
        String $jobName = this.jobName;
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        JobType $jobType = this.jobType;
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $jobParameter = this.jobParameter;
        result = result * 59 + ($jobParameter == null ? 43 : $jobParameter.hashCode());
        String $jobExecutor = this.jobExecutor;
        result = result * 59 + ($jobExecutor == null ? 43 : $jobExecutor.hashCode());
        String $jobCron = this.jobCron;
        result = result * 59 + ($jobCron == null ? 43 : $jobCron.hashCode());
        String $shardingItemParameters = this.shardingItemParameters;
        result = result * 59 + ($shardingItemParameters == null ? 43 : $shardingItemParameters.hashCode());
        String $jobShardingStrategy = this.jobShardingStrategy;
        result = result * 59 + ($jobShardingStrategy == null ? 43 : $jobShardingStrategy.hashCode());
        String $jobAttrs = this.jobAttrs;
        result = result * 59 + ($jobAttrs == null ? 43 : $jobAttrs.hashCode());
        String $jobExceptionHandler = this.jobExceptionHandler;
        result = result * 59 + ($jobExceptionHandler == null ? 43 : $jobExceptionHandler.hashCode());
        String $executorServiceHandler = this.executorServiceHandler;
        result = result * 59 + ($executorServiceHandler == null ? 43 : $executorServiceHandler.hashCode());
        String $crtUserName = this.crtUserName;
        result = result * 59 + ($crtUserName == null ? 43 : $crtUserName.hashCode());
        Date $crtDt = this.crtDt;
        result = result * 59 + ($crtDt == null ? 43 : ((Object)$crtDt).hashCode());
        String $uptUserName = this.uptUserName;
        result = result * 59 + ($uptUserName == null ? 43 : $uptUserName.hashCode());
        Date $uptDt = this.uptDt;
        result = result * 59 + ($uptDt == null ? 43 : ((Object)$uptDt).hashCode());
        Class<?> $jobExecutorClass = this.jobExecutorClass;
        result = result * 59 + ($jobExecutorClass == null ? 43 : $jobExecutorClass.hashCode());
        return result;
    }

    public String toString() {
        return "JobCfgEntity(id=" + this.id + ", profile=" + this.profile + ", sysId=" + this.sysId + ", jobName=" + this.jobName + ", jobType=" + this.jobType + ", description=" + this.description + ", jobParameter=" + this.jobParameter + ", jobExecutor=" + this.jobExecutor + ", jobCron=" + this.jobCron + ", shardingEnabled=" + this.shardingEnabled + ", shardingTotalCount=" + this.shardingTotalCount + ", shardingItemParameters=" + this.shardingItemParameters + ", failover=" + this.failover + ", misfire=" + this.misfire + ", streamingProcess=" + this.streamingProcess + ", monitorExecution=" + this.monitorExecution + ", maxTimeDiffSeconds=" + this.maxTimeDiffSeconds + ", monitorPort=" + this.monitorPort + ", jobShardingStrategy=" + this.jobShardingStrategy + ", disabled=" + this.disabled + ", overwrite=" + this.overwrite + ", reconcileIntervalMinutes=" + this.reconcileIntervalMinutes + ", jobAttrs=" + this.jobAttrs + ", jobExceptionHandler=" + this.jobExceptionHandler + ", executorServiceHandler=" + this.executorServiceHandler + ", executorPoolSize=" + this.executorPoolSize + ", deleted=" + this.deleted + ", crtUser=" + this.crtUser + ", crtUserName=" + this.crtUserName + ", crtDt=" + this.crtDt + ", uptUser=" + this.uptUser + ", uptUserName=" + this.uptUserName + ", uptDt=" + this.uptDt + ", jobExecutorClass=" + this.jobExecutorClass + ")";
    }

    public JobCfgEntity(String id, String profile, String sysId, String jobName, JobType jobType, String description, String jobParameter, String jobExecutor, String jobCron, Boolean shardingEnabled, Integer shardingTotalCount, String shardingItemParameters, Boolean failover, Boolean misfire, Boolean streamingProcess, Boolean monitorExecution, Integer maxTimeDiffSeconds, Integer monitorPort, String jobShardingStrategy, Boolean disabled, Boolean overwrite, Integer reconcileIntervalMinutes, String jobAttrs, String jobExceptionHandler, String executorServiceHandler, Long executorPoolSize, Boolean deleted, Long crtUser, String crtUserName, Date crtDt, Long uptUser, String uptUserName, Date uptDt, Class<?> jobExecutorClass) {
        this.id = id;
        this.profile = profile;
        this.sysId = sysId;
        this.jobName = jobName;
        this.jobType = jobType;
        this.description = description;
        this.jobParameter = jobParameter;
        this.jobExecutor = jobExecutor;
        this.jobCron = jobCron;
        this.shardingEnabled = shardingEnabled;
        this.shardingTotalCount = shardingTotalCount;
        this.shardingItemParameters = shardingItemParameters;
        this.failover = failover;
        this.misfire = misfire;
        this.streamingProcess = streamingProcess;
        this.monitorExecution = monitorExecution;
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
        this.monitorPort = monitorPort;
        this.jobShardingStrategy = jobShardingStrategy;
        this.disabled = disabled;
        this.overwrite = overwrite;
        this.reconcileIntervalMinutes = reconcileIntervalMinutes;
        this.jobAttrs = jobAttrs;
        this.jobExceptionHandler = jobExceptionHandler;
        this.executorServiceHandler = executorServiceHandler;
        this.executorPoolSize = executorPoolSize;
        this.deleted = deleted;
        this.crtUser = crtUser;
        this.crtUserName = crtUserName;
        this.crtDt = crtDt;
        this.uptUser = uptUser;
        this.uptUserName = uptUserName;
        this.uptDt = uptDt;
        this.jobExecutorClass = jobExecutorClass;
    }

    public JobCfgEntity() {
        this.description = JobCfgEntity.$default$description();
        this.jobParameter = JobCfgEntity.$default$jobParameter();
        this.shardingItemParameters = JobCfgEntity.$default$shardingItemParameters();
        this.failover = JobCfgEntity.$default$failover();
        this.misfire = JobCfgEntity.$default$misfire();
        this.streamingProcess = JobCfgEntity.$default$streamingProcess();
        this.monitorExecution = JobCfgEntity.$default$monitorExecution();
        this.maxTimeDiffSeconds = JobCfgEntity.$default$maxTimeDiffSeconds();
        this.monitorPort = JobCfgEntity.$default$monitorPort();
        this.jobShardingStrategy = JobCfgEntity.$default$jobShardingStrategy();
        this.reconcileIntervalMinutes = JobCfgEntity.$default$reconcileIntervalMinutes();
    }

    public static final class Fields {
        public static final String id = "id";
        public static final String profile = "profile";
        public static final String sysId = "sysId";
        public static final String jobName = "jobName";
        public static final String jobType = "jobType";
        public static final String description = "description";
        public static final String jobParameter = "jobParameter";
        public static final String jobExecutor = "jobExecutor";
        public static final String jobCron = "jobCron";
        public static final String shardingEnabled = "shardingEnabled";
        public static final String shardingTotalCount = "shardingTotalCount";
        public static final String shardingItemParameters = "shardingItemParameters";
        public static final String failover = "failover";
        public static final String misfire = "misfire";
        public static final String streamingProcess = "streamingProcess";
        public static final String monitorExecution = "monitorExecution";
        public static final String maxTimeDiffSeconds = "maxTimeDiffSeconds";
        public static final String monitorPort = "monitorPort";
        public static final String jobShardingStrategy = "jobShardingStrategy";
        public static final String disabled = "disabled";
        public static final String overwrite = "overwrite";
        public static final String reconcileIntervalMinutes = "reconcileIntervalMinutes";
        public static final String jobAttrs = "jobAttrs";
        public static final String jobExceptionHandler = "jobExceptionHandler";
        public static final String executorServiceHandler = "executorServiceHandler";
        public static final String executorPoolSize = "executorPoolSize";
        public static final String deleted = "deleted";
        public static final String crtUser = "crtUser";
        public static final String crtUserName = "crtUserName";
        public static final String crtDt = "crtDt";
        public static final String uptUser = "uptUser";
        public static final String uptUserName = "uptUserName";
        public static final String uptDt = "uptDt";
        public static final String jobExecutorClass = "jobExecutorClass";

        private Fields() {
        }
    }

    public static class JobCfgEntityBuilder {
        private String id;
        private String profile;
        private String sysId;
        private String jobName;
        private JobType jobType;
        private boolean description$set;
        private String description$value;
        private boolean jobParameter$set;
        private String jobParameter$value;
        private String jobExecutor;
        private String jobCron;
        private Boolean shardingEnabled;
        private Integer shardingTotalCount;
        private boolean shardingItemParameters$set;
        private String shardingItemParameters$value;
        private boolean failover$set;
        private Boolean failover$value;
        private boolean misfire$set;
        private Boolean misfire$value;
        private boolean streamingProcess$set;
        private Boolean streamingProcess$value;
        private boolean monitorExecution$set;
        private Boolean monitorExecution$value;
        private boolean maxTimeDiffSeconds$set;
        private Integer maxTimeDiffSeconds$value;
        private boolean monitorPort$set;
        private Integer monitorPort$value;
        private boolean jobShardingStrategy$set;
        private String jobShardingStrategy$value;
        private Boolean disabled;
        private Boolean overwrite;
        private boolean reconcileIntervalMinutes$set;
        private Integer reconcileIntervalMinutes$value;
        private String jobAttrs;
        private String jobExceptionHandler;
        private String executorServiceHandler;
        private Long executorPoolSize;
        private Boolean deleted;
        private Long crtUser;
        private String crtUserName;
        private Date crtDt;
        private Long uptUser;
        private String uptUserName;
        private Date uptDt;
        private Class<?> jobExecutorClass;

        JobCfgEntityBuilder() {
        }

        public JobCfgEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public JobCfgEntityBuilder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public JobCfgEntityBuilder sysId(String sysId) {
            this.sysId = sysId;
            return this;
        }

        public JobCfgEntityBuilder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public JobCfgEntityBuilder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public JobCfgEntityBuilder description(String description) {
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        public JobCfgEntityBuilder jobParameter(String jobParameter) {
            this.jobParameter$value = jobParameter;
            this.jobParameter$set = true;
            return this;
        }

        public JobCfgEntityBuilder jobExecutor(String jobExecutor) {
            this.jobExecutor = jobExecutor;
            return this;
        }

        public JobCfgEntityBuilder jobCron(String jobCron) {
            this.jobCron = jobCron;
            return this;
        }

        public JobCfgEntityBuilder shardingEnabled(Boolean shardingEnabled) {
            this.shardingEnabled = shardingEnabled;
            return this;
        }

        public JobCfgEntityBuilder shardingTotalCount(Integer shardingTotalCount) {
            this.shardingTotalCount = shardingTotalCount;
            return this;
        }

        public JobCfgEntityBuilder shardingItemParameters(String shardingItemParameters) {
            this.shardingItemParameters$value = shardingItemParameters;
            this.shardingItemParameters$set = true;
            return this;
        }

        public JobCfgEntityBuilder failover(Boolean failover) {
            this.failover$value = failover;
            this.failover$set = true;
            return this;
        }

        public JobCfgEntityBuilder misfire(Boolean misfire) {
            this.misfire$value = misfire;
            this.misfire$set = true;
            return this;
        }

        public JobCfgEntityBuilder streamingProcess(Boolean streamingProcess) {
            this.streamingProcess$value = streamingProcess;
            this.streamingProcess$set = true;
            return this;
        }

        public JobCfgEntityBuilder monitorExecution(Boolean monitorExecution) {
            this.monitorExecution$value = monitorExecution;
            this.monitorExecution$set = true;
            return this;
        }

        public JobCfgEntityBuilder maxTimeDiffSeconds(Integer maxTimeDiffSeconds) {
            this.maxTimeDiffSeconds$value = maxTimeDiffSeconds;
            this.maxTimeDiffSeconds$set = true;
            return this;
        }

        public JobCfgEntityBuilder monitorPort(Integer monitorPort) {
            this.monitorPort$value = monitorPort;
            this.monitorPort$set = true;
            return this;
        }

        public JobCfgEntityBuilder jobShardingStrategy(String jobShardingStrategy) {
            this.jobShardingStrategy$value = jobShardingStrategy;
            this.jobShardingStrategy$set = true;
            return this;
        }

        public JobCfgEntityBuilder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public JobCfgEntityBuilder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public JobCfgEntityBuilder reconcileIntervalMinutes(Integer reconcileIntervalMinutes) {
            this.reconcileIntervalMinutes$value = reconcileIntervalMinutes;
            this.reconcileIntervalMinutes$set = true;
            return this;
        }

        public JobCfgEntityBuilder jobAttrs(String jobAttrs) {
            this.jobAttrs = jobAttrs;
            return this;
        }

        public JobCfgEntityBuilder jobExceptionHandler(String jobExceptionHandler) {
            this.jobExceptionHandler = jobExceptionHandler;
            return this;
        }

        public JobCfgEntityBuilder executorServiceHandler(String executorServiceHandler) {
            this.executorServiceHandler = executorServiceHandler;
            return this;
        }

        public JobCfgEntityBuilder executorPoolSize(Long executorPoolSize) {
            this.executorPoolSize = executorPoolSize;
            return this;
        }

        public JobCfgEntityBuilder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public JobCfgEntityBuilder crtUser(Long crtUser) {
            this.crtUser = crtUser;
            return this;
        }

        public JobCfgEntityBuilder crtUserName(String crtUserName) {
            this.crtUserName = crtUserName;
            return this;
        }

        public JobCfgEntityBuilder crtDt(Date crtDt) {
            this.crtDt = crtDt;
            return this;
        }

        public JobCfgEntityBuilder uptUser(Long uptUser) {
            this.uptUser = uptUser;
            return this;
        }

        public JobCfgEntityBuilder uptUserName(String uptUserName) {
            this.uptUserName = uptUserName;
            return this;
        }

        public JobCfgEntityBuilder uptDt(Date uptDt) {
            this.uptDt = uptDt;
            return this;
        }

        public JobCfgEntityBuilder jobExecutorClass(Class<?> jobExecutorClass) {
            this.jobExecutorClass = jobExecutorClass;
            return this;
        }

        public JobCfgEntity build() {
            String description$value = this.description$value;
            if (!this.description$set) {
                description$value = JobCfgEntity.$default$description();
            }
            String jobParameter$value = this.jobParameter$value;
            if (!this.jobParameter$set) {
                jobParameter$value = JobCfgEntity.$default$jobParameter();
            }
            String shardingItemParameters$value = this.shardingItemParameters$value;
            if (!this.shardingItemParameters$set) {
                shardingItemParameters$value = JobCfgEntity.$default$shardingItemParameters();
            }
            Boolean failover$value = this.failover$value;
            if (!this.failover$set) {
                failover$value = JobCfgEntity.$default$failover();
            }
            Boolean misfire$value = this.misfire$value;
            if (!this.misfire$set) {
                misfire$value = JobCfgEntity.$default$misfire();
            }
            Boolean streamingProcess$value = this.streamingProcess$value;
            if (!this.streamingProcess$set) {
                streamingProcess$value = JobCfgEntity.$default$streamingProcess();
            }
            Boolean monitorExecution$value = this.monitorExecution$value;
            if (!this.monitorExecution$set) {
                monitorExecution$value = JobCfgEntity.$default$monitorExecution();
            }
            Integer maxTimeDiffSeconds$value = this.maxTimeDiffSeconds$value;
            if (!this.maxTimeDiffSeconds$set) {
                maxTimeDiffSeconds$value = JobCfgEntity.$default$maxTimeDiffSeconds();
            }
            Integer monitorPort$value = this.monitorPort$value;
            if (!this.monitorPort$set) {
                monitorPort$value = JobCfgEntity.$default$monitorPort();
            }
            String jobShardingStrategy$value = this.jobShardingStrategy$value;
            if (!this.jobShardingStrategy$set) {
                jobShardingStrategy$value = JobCfgEntity.$default$jobShardingStrategy();
            }
            Integer reconcileIntervalMinutes$value = this.reconcileIntervalMinutes$value;
            if (!this.reconcileIntervalMinutes$set) {
                reconcileIntervalMinutes$value = JobCfgEntity.$default$reconcileIntervalMinutes();
            }
            return new JobCfgEntity(this.id, this.profile, this.sysId, this.jobName, this.jobType, description$value, jobParameter$value, this.jobExecutor, this.jobCron, this.shardingEnabled, this.shardingTotalCount, shardingItemParameters$value, failover$value, misfire$value, streamingProcess$value, monitorExecution$value, maxTimeDiffSeconds$value, monitorPort$value, jobShardingStrategy$value, this.disabled, this.overwrite, reconcileIntervalMinutes$value, this.jobAttrs, this.jobExceptionHandler, this.executorServiceHandler, this.executorPoolSize, this.deleted, this.crtUser, this.crtUserName, this.crtDt, this.uptUser, this.uptUserName, this.uptDt, this.jobExecutorClass);
        }

        public String toString() {
            return "JobCfgEntity.JobCfgEntityBuilder(id=" + this.id + ", profile=" + this.profile + ", sysId=" + this.sysId + ", jobName=" + this.jobName + ", jobType=" + this.jobType + ", description$value=" + this.description$value + ", jobParameter$value=" + this.jobParameter$value + ", jobExecutor=" + this.jobExecutor + ", jobCron=" + this.jobCron + ", shardingEnabled=" + this.shardingEnabled + ", shardingTotalCount=" + this.shardingTotalCount + ", shardingItemParameters$value=" + this.shardingItemParameters$value + ", failover$value=" + this.failover$value + ", misfire$value=" + this.misfire$value + ", streamingProcess$value=" + this.streamingProcess$value + ", monitorExecution$value=" + this.monitorExecution$value + ", maxTimeDiffSeconds$value=" + this.maxTimeDiffSeconds$value + ", monitorPort$value=" + this.monitorPort$value + ", jobShardingStrategy$value=" + this.jobShardingStrategy$value + ", disabled=" + this.disabled + ", overwrite=" + this.overwrite + ", reconcileIntervalMinutes$value=" + this.reconcileIntervalMinutes$value + ", jobAttrs=" + this.jobAttrs + ", jobExceptionHandler=" + this.jobExceptionHandler + ", executorServiceHandler=" + this.executorServiceHandler + ", executorPoolSize=" + this.executorPoolSize + ", deleted=" + this.deleted + ", crtUser=" + this.crtUser + ", crtUserName=" + this.crtUserName + ", crtDt=" + this.crtDt + ", uptUser=" + this.uptUser + ", uptUserName=" + this.uptUserName + ", uptDt=" + this.uptDt + ", jobExecutorClass=" + this.jobExecutorClass + ")";
        }
    }
}

