/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.context;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.JobType;
import com.dangdang.ddframe.job.api.dataflow.DataflowJob;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.config.dataflow.DataflowJobConfiguration;
import com.dangdang.ddframe.job.config.script.ScriptJobConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import com.dangdang.ddframe.job.executor.handler.impl.DefaultJobExceptionHandler;
import com.dangdang.ddframe.job.lite.api.JobScheduler;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategy;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.lite.lifecycle.domain.JobSettings;
import com.dangdang.ddframe.job.lite.spring.api.SpringJobScheduler;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import com.google.common.base.Optional;
import io.polaris.core.annotation.Internal;
import io.polaris.core.err.Exceptions;
import io.polaris.core.lang.Objs;
import io.polaris.core.os.OS;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import io.polaris.core.time.Dates;
import io.polaris.framework.core.context.AppCtx;
import io.polaris.framework.core.gray.GrayCapable;
import io.polaris.framework.toolkit.elasticjob.base.QuartzJobDelegate;
import io.polaris.framework.toolkit.elasticjob.context.DefaultSchedulerHolder;
import io.polaris.framework.toolkit.elasticjob.context.ElasticJobListenerImpl;
import io.polaris.framework.toolkit.elasticjob.context.ElasticSchedulerHolder;
import io.polaris.framework.toolkit.elasticjob.context.JobApi;
import io.polaris.framework.toolkit.elasticjob.context.JobState;
import io.polaris.framework.toolkit.elasticjob.entity.JobCfgEntity;
import io.polaris.framework.toolkit.elasticjob.entity.JobEnvEntity;
import io.polaris.framework.toolkit.elasticjob.entity.JobRuntimeEntity;
import io.polaris.framework.toolkit.elasticjob.err.JobException;
import io.polaris.framework.toolkit.elasticjob.ext.JobEventRdbConfiguration;
import io.polaris.framework.toolkit.elasticjob.ext.RotateServerNodeJobShardingStrategy;
import io.polaris.framework.toolkit.elasticjob.handler.DynamicExecutorServiceHandler;
import io.polaris.framework.toolkit.elasticjob.properties.ElasticJobProperties;
import io.polaris.framework.toolkit.elasticjob.properties.JobCoreProperties;
import io.polaris.framework.toolkit.elasticjob.properties.JobsProperties;
import io.polaris.framework.toolkit.elasticjob.repository.JobRepository;
import io.polaris.framework.toolkit.elasticjob.repository.JobRuntimeRepository;
import io.polaris.framework.toolkit.elasticjob.repository.NoopJobRepository;
import io.polaris.framework.toolkit.elasticjob.repository.NoopJobRuntimeRepository;
import io.polaris.framework.toolkit.elasticjob.repository.RdbJobRepository;
import io.polaris.framework.toolkit.elasticjob.repository.RdbJobRuntimeRepository;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class JobCtx {
    private static final Logger log = LoggerFactory.getLogger(JobCtx.class);
    public static final Class<? extends JobShardingStrategy> DEFAULT_JOB_SHARDING_STRATEGY = RotateServerNodeJobShardingStrategy.class;
    public static final String DEFAULT_INSTANCE_REG_PATH = "@instances";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ElasticJobProperties properties;
    private final JobEventConfiguration jobEventConfig;
    private final ConfigurableApplicationContext context;
    private final boolean enabledRdbEvent;
    private final DataSource dataSource;
    private final JobRepository jobRepository;
    private final JobRuntimeRepository jobRuntimeRepository;
    private final String profile;
    private final String sysId;
    private final String vmProcessUid;
    private final long vmStartTime;
    private JobEnvEntity jobEnv;
    private DefaultSchedulerHolder defaultInstance;
    private ElasticSchedulerHolder elasticInstance;
    private Map<String, JobRuntimeEntity> jobs = Collections.synchronizedMap(new LinkedHashMap());

    public JobCtx(ConfigurableApplicationContext context, DataSource dataSource, JobRepository jobRepository, ElasticJobProperties properties) {
        this.context = context;
        this.dataSource = dataSource;
        this.properties = properties;
        this.enabledRdbEvent = properties.isEnabledRdbEvent();
        this.jobRepository = jobRepository != null ? jobRepository : (this.enabledRdbEvent ? new RdbJobRepository(dataSource) : new NoopJobRepository());
        this.jobRuntimeRepository = this.enabledRdbEvent ? new RdbJobRuntimeRepository(dataSource) : new NoopJobRuntimeRepository();
        this.jobEventConfig = new JobEventRdbConfiguration(this);
        this.profile = AppCtx.getActiveProfile();
        this.sysId = AppCtx.getPlatformProperties().getAppId();
        List<String> hostPatterns = properties.getZookeeper().getInstanceHostPatterns();
        if (hostPatterns != null) {
            String[] regex = hostPatterns.toArray(new String[0]);
            this.vmProcessUid = OS.getPriorOrFirstIp((String[])regex) + "#" + OS.getPid();
        } else {
            this.vmProcessUid = OS.getFirstIp() + "#" + OS.getPid();
        }
        this.vmStartTime = OS.getVmStartTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.warn("\u8fd0\u884cJVM\u865a\u62df\u673a\u505c\u6b62\u94a9\u5b50: \u505c\u6b62Job\u4e0a\u4e0b\u6587");
            if (this.started.get()) {
                this.shutdown();
            }
        }));
    }

    @Internal
    public synchronized void bindZookeeperRegistryCenter(ZookeeperRegistryCenter regCenter) {
        if (regCenter == null) {
            return;
        }
        if (this.elasticInstance != null) {
            throw new JobException("\u5df2\u5b58\u5728 ZookeeperRegistryCenter \u5b9e\u4f8b");
        }
        Method method = Reflects.getMethod(ZookeeperRegistryCenter.class, (String)"getZkConfig", (Class[])new Class[0]);
        ZookeeperConfiguration zkConfig = (ZookeeperConfiguration)Reflects.invokeQuietly((Object)regCenter, (Method)method, (Object[])new Object[0]);
        this.jobEnv = new JobEnvEntity();
        this.jobEnv.setProfile(this.profile);
        this.jobEnv.setSysId(this.sysId);
        this.jobEnv.setZkJobNamespace(zkConfig.getNamespace());
        this.jobEnv.setZkAddress(zkConfig.getServerLists());
        this.jobEnv.setZkRegPath(this.properties.getZookeeper().getInstanceRegPath());
        if (Strings.isBlank((CharSequence)this.jobEnv.getZkRegPath())) {
            this.jobEnv.setZkRegPath(DEFAULT_INSTANCE_REG_PATH);
        } else {
            this.jobEnv.setZkRegPath(this.jobEnv.getZkRegPath().replaceFirst("^/+", "").replaceFirst("/+$", ""));
        }
        this.jobEnv.setBaseSleepTime(zkConfig.getBaseSleepTimeMilliseconds());
        this.jobEnv.setMaxSleepTime(zkConfig.getMaxSleepTimeMilliseconds());
        this.jobEnv.setMaxRetries(zkConfig.getMaxRetries());
        this.jobEnv.setSessionTimeout(zkConfig.getSessionTimeoutMilliseconds());
        this.jobEnv.setConnectionTimeout(zkConfig.getConnectionTimeoutMilliseconds());
        this.jobEnv.setDigest(zkConfig.getDigest());
        this.elasticInstance = new ElasticSchedulerHolder(regCenter, zkConfig);
    }

    public ZookeeperRegistryCenter getZookeeperRegistryCenter() {
        if (this.elasticInstance == null) {
            this.initElasticInstance();
        }
        return this.elasticInstance.getRegCenter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        block6: {
            log.info("\u542f\u52a8\u4f5c\u4e1a\u8c03\u5ea6...");
            try {
                if (this.started.get()) break block6;
                JobCtx jobCtx = this;
                synchronized (jobCtx) {
                    if (!this.started.get()) {
                        this.initEnv();
                        this.registerElasticInstanceNode();
                        this.initElasticJob();
                        this.checkElasticJob();
                        this.startElasticJob();
                        this.started.set(true);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u542f\u52a8\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                this.shutdown();
            }
        }
    }

    public JobRuntimeEntity getJobRuntime(String jobName) {
        JobRuntimeEntity jobRuntime = this.jobs.get(jobName);
        if (jobRuntime == null) {
            return null;
        }
        return jobRuntime.clone();
    }

    public synchronized void reload() {
        String[] jobNames;
        log.info("\u91cd\u65b0\u52a0\u8f7d\u4f5c\u4e1a\u914d\u7f6e");
        Map<String, JobRuntimeEntity> entityMap = this.initializeAllJobEntities();
        for (String jobName2 : jobNames = this.jobs.keySet().toArray(new String[0])) {
            JobRuntimeEntity jobRuntime2 = entityMap.get(jobName2);
            if (jobRuntime2 != null) {
                entityMap.remove(jobName2);
            }
            this.reload(jobName2, jobRuntime2);
        }
        entityMap.forEach((jobName, jobRuntime) -> this.reload((String)jobName, (JobRuntimeEntity)jobRuntime));
    }

    public synchronized void reload(String jobName) {
        this.reload(jobName, this.initializeJobEntity(jobName));
    }

    public synchronized void reload(String jobName, JobRuntimeEntity jobRuntime) {
        log.info("\u91cd\u65b0\u52a0\u8f7d\u4f5c\u4e1a\u914d\u7f6e: {}", (Object)jobName);
        JobRuntimeEntity currJobRuntime = this.jobs.get(jobName);
        if (currJobRuntime != null) {
            this.shutdownJob(jobName);
        }
        if (jobRuntime == null) {
            log.warn("\u4f5c\u4e1a\u914d\u7f6e\u4e0d\u5b58\u5728: {}", (Object)jobName);
            return;
        }
        if (currJobRuntime != null) {
            jobRuntime.setId(currJobRuntime.getId());
            jobRuntime.setMessage("\u91cd\u65b0\u52a0\u8f7d\u4f5c\u4e1a\u914d\u7f6e");
            this.jobs.put(jobName, jobRuntime);
            this.jobRuntimeRepository.updateJobRuntime(jobRuntime);
        } else {
            this.jobs.put(jobName, jobRuntime);
            this.jobRuntimeRepository.insertJobRuntimeList(Collections.singletonList(jobRuntime));
        }
        try {
            this.scheduleJob(jobRuntime);
            this.doUpdateJobState(jobRuntime, JobState.INITIAL, "\u751f\u6210\u8c03\u5ea6\u4f5c\u4e1a");
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25", (Throwable)e);
            this.doUpdateJobState(jobRuntime, "\u751f\u6210\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public synchronized void shutdown() {
        log.info("\u505c\u6b62\u4e0a\u4e0b\u6587");
        for (JobRuntimeEntity job : this.jobs.values()) {
            if (!Boolean.TRUE.equals(job.getShardingEnabled())) {
                try {
                    this.defaultInstance.getScheduler().deleteJob(this.defaultInstance.jobKey(job.getJobName()));
                }
                catch (SchedulerException e) {
                    throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u505c\u6b62\u5931\u8d25: " + job.getJobName(), e);
                }
            }
            this.doUpdateJobState(job, JobState.TERMINATED, "\u5173\u95ed\u4f5c\u4e1a\u8c03\u5ea6");
        }
        this.started.set(false);
        this.jobs.clear();
        if (this.elasticInstance != null) {
            this.elasticInstance.close();
            this.elasticInstance = null;
        }
        if (this.defaultInstance != null) {
            this.defaultInstance.close();
            this.defaultInstance = null;
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private void initEnv() {
        this.initJobEnv();
        this.initElasticInstance();
        this.initDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJobEnv() {
        if (this.jobEnv != null) {
            return;
        }
        JobCtx jobCtx = this;
        synchronized (jobCtx) {
            String instanceRegPath;
            Integer connectionTimeoutMilliseconds;
            Integer sessionTimeoutMilliseconds;
            Integer maxRetries;
            Integer maxSleepTimeMilliseconds;
            Integer baseSleepTimeMilliseconds;
            if (this.jobEnv != null) {
                return;
            }
            JobEnvEntity jobEnvEntity = this.jobRepository.getJobEnv(this.profile, this.sysId);
            if (jobEnvEntity == null) {
                jobEnvEntity = new JobEnvEntity();
                jobEnvEntity.setProfile(this.profile);
                jobEnvEntity.setSysId(this.sysId);
            }
            String serverLists = this.properties.getZookeeper().getServerLists();
            String digest = this.properties.getZookeeper().getDigest();
            if (Strings.isNotBlank((CharSequence)serverLists)) {
                jobEnvEntity.setZkAddress(serverLists);
                jobEnvEntity.setDigest(digest);
            }
            if (Strings.isBlank((CharSequence)jobEnvEntity.getZkAddress())) {
                throw new IllegalArgumentException("Zookeeper\u670d\u52a1\u5730\u5740\u672a\u914d\u7f6e");
            }
            String namespace = this.properties.getZookeeper().getNamespace();
            if (Strings.isNotBlank((CharSequence)namespace)) {
                jobEnvEntity.setZkJobNamespace(namespace);
            }
            if (Strings.isBlank((CharSequence)jobEnvEntity.getZkJobNamespace())) {
                jobEnvEntity.setZkJobNamespace("elastic-job-" + this.sysId);
            }
            if (Strings.isNotBlank((CharSequence)jobEnvEntity.getZkJobNamespace())) {
                jobEnvEntity.setZkJobNamespace(jobEnvEntity.getZkJobNamespace().replaceFirst("^/+", ""));
            }
            if (AppCtx.getPlatformProperties().getGray().isEnabled()) {
                jobEnvEntity.setZkJobNamespace("gray-" + AppCtx.getPlatformProperties().getGray().getEnv() + "-" + jobEnvEntity.getZkJobNamespace());
            }
            if ((baseSleepTimeMilliseconds = this.properties.getZookeeper().getBaseSleepTimeMilliseconds()) != null) {
                jobEnvEntity.setBaseSleepTime(baseSleepTimeMilliseconds);
            }
            if ((maxSleepTimeMilliseconds = this.properties.getZookeeper().getMaxSleepTimeMilliseconds()) != null) {
                jobEnvEntity.setMaxSleepTime(maxSleepTimeMilliseconds);
            }
            if ((maxRetries = this.properties.getZookeeper().getMaxRetries()) != null) {
                jobEnvEntity.setMaxRetries(maxRetries);
            }
            if ((sessionTimeoutMilliseconds = this.properties.getZookeeper().getSessionTimeoutMilliseconds()) != null) {
                jobEnvEntity.setSessionTimeout(sessionTimeoutMilliseconds);
            }
            if ((connectionTimeoutMilliseconds = this.properties.getZookeeper().getConnectionTimeoutMilliseconds()) != null) {
                jobEnvEntity.setConnectionTimeout(connectionTimeoutMilliseconds);
            }
            if (Strings.isNotBlank((CharSequence)(instanceRegPath = this.properties.getZookeeper().getInstanceRegPath()))) {
                jobEnvEntity.setZkRegPath(instanceRegPath.replaceFirst("^/+", "").replaceFirst("/+$", ""));
            }
            if (Strings.isBlank((CharSequence)jobEnvEntity.getZkRegPath())) {
                jobEnvEntity.setZkRegPath(DEFAULT_INSTANCE_REG_PATH);
            } else {
                jobEnvEntity.setZkRegPath(jobEnvEntity.getZkRegPath().replaceFirst("^/+", "").replaceFirst("/+$", ""));
            }
            this.jobEnv = jobEnvEntity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultInstance() {
        if (this.defaultInstance != null) {
            return;
        }
        JobCtx jobCtx = this;
        synchronized (jobCtx) {
            if (this.defaultInstance != null) {
                return;
            }
            this.defaultInstance = new DefaultSchedulerHolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initElasticInstance() {
        if (this.elasticInstance != null) {
            return;
        }
        JobCtx jobCtx = this;
        synchronized (jobCtx) {
            if (this.elasticInstance != null) {
                return;
            }
            this.elasticInstance = new ElasticSchedulerHolder(this.jobEnv, this.dataSource);
        }
    }

    private void registerElasticInstanceNode() {
        CuratorFramework zkClient = this.elasticInstance.getRegCenter().getClient();
        String path = "/" + this.jobEnv.getZkRegPath().replaceFirst("^/+", "").replaceFirst("/+$", "") + "/" + this.vmProcessUid;
        boolean registered = false;
        int tryTimes = 3;
        Exception err = null;
        for (int i = 0; i < tryTimes; ++i) {
            try {
                log.info("\u6ce8\u518cZookeeper\u4f5c\u4e1a\u6267\u884c\u7aef\u8282\u70b9,namespace:{},path:{},state:{}", new Object[]{zkClient.getNamespace(), path, zkClient.getState()});
                ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path);
                zkClient.setData().forPath(path, (this.vmProcessUid + "@" + Dates.YYYY_MM_DD_HH_MM_SS_SSS.format(Instant.now())).getBytes());
                registered = true;
                break;
            }
            catch (Exception e) {
                log.debug("\u6ce8\u518c\u8282\u70b9\u5931\u8d25", (Throwable)e);
                err = e;
                continue;
            }
        }
        if (!registered) {
            throw new JobException("\u6ce8\u518cZookeeper\u4f5c\u4e1a\u6267\u884c\u7aef\u8282\u70b9\u5931\u8d25", err);
        }
    }

    private List<String> getAllRegisterInstanceNodes() throws Exception {
        CuratorFramework client = this.elasticInstance.getRegCenter().getClient();
        List list = (List)client.getChildren().forPath("/" + this.jobEnv.getZkRegPath().replaceFirst("^/+", "").replaceFirst("/+$", ""));
        return Collections.unmodifiableList(list);
    }

    private Map<String, JobRuntimeEntity> initializeAllJobEntities() {
        List<JobCfgEntity> jobCfgList;
        LinkedHashMap<String, JobRuntimeEntity> jobRuntimeMap = new LinkedHashMap<String, JobRuntimeEntity>();
        JobsProperties jobsProperties = this.properties.getJobs();
        if (jobsProperties != null) {
            if (jobsProperties.getSimpleJobs() != null) {
                jobsProperties.getSimpleJobs().forEach((jobName, props) -> {
                    if (!props.isEnabled()) {
                        log.warn("\u4f5c\u4e1a\u8c03\u5ea6{}\u672a\u542f\u7528\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e", jobName);
                        return;
                    }
                    if (jobRuntimeMap.containsKey(jobName)) {
                        log.warn("\u4f5c\u4e1a\u8c03\u5ea6{}\u547d\u540d\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e", jobName);
                        return;
                    }
                    jobRuntimeMap.putIfAbsent((String)jobName, this.newJobRuntime((JobCoreProperties)props, (String)jobName));
                });
            }
            if (jobsProperties.getDataflowJobs() != null) {
                jobsProperties.getDataflowJobs().forEach((jobName, props) -> {
                    if (!props.isEnabled()) {
                        log.warn("\u4f5c\u4e1a\u8c03\u5ea6{}\u672a\u542f\u7528\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e", jobName);
                        return;
                    }
                    if (jobRuntimeMap.containsKey(jobName)) {
                        log.warn("\u4f5c\u4e1a\u8c03\u5ea6{}\u547d\u540d\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e", jobName);
                        return;
                    }
                    jobRuntimeMap.putIfAbsent((String)jobName, this.newJobRuntime((JobCoreProperties)props, (String)jobName));
                });
            }
            if (jobsProperties.getScriptJobs() != null) {
                jobsProperties.getScriptJobs().forEach((jobName, props) -> {
                    if (!props.isEnabled()) {
                        log.warn("\u4f5c\u4e1a\u8c03\u5ea6{}\u672a\u542f\u7528\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e", jobName);
                        return;
                    }
                    if (jobRuntimeMap.containsKey(jobName)) {
                        log.warn("\u4f5c\u4e1a\u8c03\u5ea6{}\u547d\u540d\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e", jobName);
                        return;
                    }
                    jobRuntimeMap.putIfAbsent((String)jobName, this.newJobRuntime((JobCoreProperties)props, (String)jobName));
                });
            }
        }
        if ((jobCfgList = this.jobRepository.getAllJobInfoCfg(this.jobEnv.getProfile(), this.jobEnv.getSysId())) != null && !jobCfgList.isEmpty()) {
            jobCfgList.forEach(cfg -> {
                if (Boolean.TRUE.equals(cfg.getDeleted())) {
                    return;
                }
                if (!jobRuntimeMap.containsKey(cfg.getJobName())) {
                    JobRuntimeEntity jobRuntime = this.newJobRuntime((JobCfgEntity)cfg);
                    jobRuntimeMap.put(jobRuntime.getJobName(), jobRuntime);
                }
            });
        }
        return jobRuntimeMap;
    }

    private JobRuntimeEntity initializeJobEntity(String jobName) {
        JobCfgEntity cfg;
        JobsProperties jobsProperties = this.properties.getJobs();
        if (jobsProperties != null) {
            JobCoreProperties props;
            if (jobsProperties.getSimpleJobs() != null && (props = jobsProperties.getSimpleJobs().get(jobName)).isEnabled()) {
                return this.newJobRuntime(props, jobName);
            }
            if (jobsProperties.getSimpleJobs() != null && (props = jobsProperties.getSimpleJobs().get(jobName)).isEnabled()) {
                return this.newJobRuntime(props, jobName);
            }
            if (jobsProperties.getDataflowJobs() != null && (props = jobsProperties.getDataflowJobs().get(jobName)).isEnabled()) {
                return this.newJobRuntime(props, jobName);
            }
            if (jobsProperties.getScriptJobs() != null && (props = jobsProperties.getScriptJobs().get(jobName)).isEnabled()) {
                return this.newJobRuntime(props, jobName);
            }
        }
        if ((cfg = this.jobRepository.getJobInfoCfg(this.jobEnv.getProfile(), this.jobEnv.getSysId(), jobName)) != null && !Boolean.TRUE.equals(cfg.getDeleted())) {
            return this.newJobRuntime(cfg);
        }
        return null;
    }

    private void initElasticJob() {
        this.jobs.putAll(this.initializeAllJobEntities());
        this.doDeleteOfflineJobRuntime();
        if (this.jobs.isEmpty()) {
            log.warn("\u65e0\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f");
        } else {
            this.doPersistJobRuntime();
        }
    }

    private void checkElasticJob() {
        boolean grayEnabled = AppCtx.getPlatformProperties().getGray().isEnabled();
        for (Map.Entry<String, JobRuntimeEntity> entry : this.jobs.entrySet()) {
            JobRuntimeEntity jobRuntime = entry.getValue();
            if (!Boolean.TRUE.equals(jobRuntime.getShardingEnabled())) continue;
            if (jobRuntime.getJobType() == JobType.DATAFLOW || jobRuntime.getJobType() == JobType.SIMPLE) {
                Class<?> jobClass = jobRuntime.getJobExecutorClass();
                if (jobRuntime.getJobType() == JobType.SIMPLE && !SimpleJob.class.isAssignableFrom(jobClass)) {
                    throw new JobException("\u4f5c\u4e1a\u6267\u884c\u5668\u7c7b\u578b\u4e0d\u5339\u914d\uff01jobName=" + jobRuntime.getJobName() + ",jobType=" + jobRuntime.getJobType() + ",jobExecutor:" + jobClass.getCanonicalName());
                }
                if (jobRuntime.getJobType() == JobType.DATAFLOW && !DataflowJob.class.isAssignableFrom(jobClass)) {
                    throw new JobException("\u4f5c\u4e1a\u6267\u884c\u5668\u7c7b\u578b\u4e0d\u5339\u914d\uff01jobName=" + jobRuntime.getJobName() + ",jobType=" + jobRuntime.getJobType() + ",jobExecutor:" + jobClass.getCanonicalName());
                }
                if (!grayEnabled || GrayCapable.class.isAssignableFrom(jobClass)) continue;
                throw new JobException("\u542f\u7528\u7070\u5ea6\u6a21\u5f0f\uff0c\u4f5c\u4e1a\u6267\u884c\u5668\u5fc5\u987b\u5b9e\u73b0\u7070\u5ea6\u529f\u80fd\uff0c\u8bf7\u7ee7\u627f\u5bf9\u5e94\u7c7b\u578b\u7684\u6846\u67b6\u7c7b\uff01jobName=" + jobRuntime.getJobName() + ",jobExecutor:" + jobClass.getCanonicalName());
            }
            if (jobRuntime.getJobType() == JobType.SCRIPT) {
                if (!Strings.isBlank((CharSequence)jobRuntime.getJobExecutor())) continue;
                throw new JobException("\u4f5c\u4e1a\u811a\u672c\u547d\u4ee4\u4e0d\u80fd\u4e3a\u7a7a\uff01jobName=" + jobRuntime.getJobName());
            }
            throw new JobException("\u4f5c\u4e1a\u7c7b\u578b\u4e0d\u652f\u6301\uff01jobName=" + jobRuntime.getJobName() + ",jobType=" + jobRuntime.getJobType());
        }
    }

    private void startElasticJob() {
        for (JobRuntimeEntity job : this.jobs.values()) {
            try {
                this.scheduleJob(job);
                this.doUpdateJobState(job, JobState.INITIAL, "\u751f\u6210\u8c03\u5ea6\u4f5c\u4e1a");
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25", (Throwable)e);
                this.doUpdateJobState(job, "\u751f\u6210\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25: " + e.getMessage(), e);
            }
        }
    }

    private JobRuntimeEntity newJobRuntime(JobCfgEntity jobCfg) {
        String id = UUID.randomUUID().toString().replace("-", "");
        return this.newJobRuntime(jobCfg, id);
    }

    private JobRuntimeEntity newJobRuntime(JobCfgEntity jobCfg, String id) {
        JobRuntimeEntity jobRuntime = JobRuntimeEntity.newEntity(jobCfg);
        jobRuntime.setJobName(jobCfg.getJobName());
        jobRuntime.setId(id);
        this.fillJobRuntimeWithEnv(jobRuntime);
        return jobRuntime;
    }

    private void fillJobRuntimeWithEnv(JobRuntimeEntity jobRuntime) {
        jobRuntime.setProfile(this.jobEnv.getProfile());
        jobRuntime.setSysId(this.jobEnv.getSysId());
        jobRuntime.setCrtDt(new Date());
        jobRuntime.setUptDt(new Date());
        jobRuntime.setDeleted(false);
        jobRuntime.setJobState(JobState.INITIAL);
        jobRuntime.setVmProcessUid(this.vmProcessUid);
        jobRuntime.setVmStartTime(new Date(this.vmStartTime));
        Thread currentThread = Thread.currentThread();
        jobRuntime.setVmThreadId(String.valueOf(currentThread.getId()));
        jobRuntime.setVmThreadName(currentThread.getName());
    }

    private JobRuntimeEntity newJobRuntime(JobCoreProperties properties, String jobName) {
        String id = UUID.randomUUID().toString().replace("-", "");
        return this.newJobRuntime(properties, jobName, id);
    }

    private JobRuntimeEntity newJobRuntime(JobCoreProperties properties, String jobName, String id) {
        JobRuntimeEntity jobRuntime = JobRuntimeEntity.newEntity(properties);
        jobRuntime.setJobName(jobName);
        jobRuntime.setId(id);
        this.fillJobRuntimeWithEnv(jobRuntime);
        return jobRuntime;
    }

    private void doDeleteOfflineJobRuntime() {
        List<String> registerNodes = null;
        try {
            registerNodes = this.getAllRegisterInstanceNodes();
        }
        catch (Exception e) {
            throw new JobException("\u83b7\u53d6\u6267\u884c\u7aef\u6ce8\u518c\u8282\u70b9\u4fe1\u606f\u5931\u8d25", e);
        }
        log.info("\u5220\u9664\u672c\u6267\u884c\u7aef\u4ee5\u53ca\u6240\u6709\u79bb\u7ebf\u6267\u884c\u7aef\u7684\u4f5c\u4e1a\u8fd0\u884c\u4fe1\u606f. \u5f53\u524d\u5728\u7ebf: {}", registerNodes);
        HashSet<String> uids = new HashSet<String>();
        uids.addAll(registerNodes);
        uids.remove(this.vmProcessUid);
        this.jobRuntimeRepository.deleteJobRuntimeExcept(this.jobEnv.getProfile(), this.jobEnv.getSysId(), uids);
    }

    private void doPersistJobRuntime() {
        Collection<JobRuntimeEntity> jobRuntimeList = this.jobs.values();
        this.jobRuntimeRepository.insertJobRuntimeList(jobRuntimeList);
    }

    private void doUpdateJobState(JobRuntimeEntity jobRuntime, JobState jobState, String message) {
        jobRuntime.setJobState(jobState);
        jobRuntime.setMessage(message);
        jobRuntime.setUptDt(new Date());
        this.jobRuntimeRepository.updateJobState(jobRuntime);
    }

    private void doUpdateJobState(JobRuntimeEntity jobRuntime, String message, Exception e) {
        jobRuntime.setJobState(JobState.ERROR);
        if (e != null) {
            String stackTrace = Exceptions.getStackTrace((Throwable)e);
            jobRuntime.setStackTrace(stackTrace != null && stackTrace.length() > 2000 ? stackTrace.substring(0, 2000) : stackTrace);
        }
        jobRuntime.setMessage(message != null && message.length() > 500 ? message.substring(0, 500) : message);
        jobRuntime.setUptDt(new Date());
        this.jobRuntimeRepository.updateJobErrorState(jobRuntime);
    }

    private void scheduleJob(JobRuntimeEntity jobRuntime) {
        try {
            CronExpression.validateExpression((String)jobRuntime.getJobCron());
        }
        catch (ParseException e) {
            throw new JobException("\u89e6\u53d1\u5668\u65f6\u95f4\u8868\u8fbe\u5f0f\u6709\u8bef! " + e.getMessage(), e);
        }
        boolean shardingEnabled = Boolean.TRUE.equals(jobRuntime.getShardingEnabled());
        if (!shardingEnabled) {
            log.info("\u751f\u6210\u672c\u5730\u8c03\u5ea6\u4f5c\u4e1a: {}", (Object)jobRuntime.getJobName());
            try {
                JobKey jobKey = this.defaultInstance.jobKey(jobRuntime.getJobName());
                JobBuilder jobBuilder = JobBuilder.newJob().ofType(QuartzJobDelegate.class).withIdentity(jobKey).withDescription(jobRuntime.getDescription()).storeDurably();
                if (Strings.isNotBlank((CharSequence)jobRuntime.getJobAttrs())) {
                    try {
                        JSONObject attrs = JSON.parseObject((String)jobRuntime.getJobAttrs());
                        attrs.forEach((k, v) -> jobBuilder.usingJobData(k, Objects.toString(v, null)));
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
                JobDetail jobDetail = jobBuilder.usingJobData("delegateClassname", jobRuntime.getJobExecutor()).usingJobData("jobRuntimeId", jobRuntime.getId()).build();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobRuntime.getJobCron())).build();
                this.defaultInstance.getScheduler().scheduleJob(jobDetail, (Trigger)trigger);
            }
            catch (JobException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JobException(e.getMessage(), e);
            }
        }
        log.info("\u751f\u6210\u5206\u7247\u8c03\u5ea6\u4f5c\u4e1a: {}", (Object)jobRuntime.getJobName());
        try {
            JobScheduler jobScheduler;
            ElasticJobListenerImpl elasticJobListener = new ElasticJobListenerImpl(this.jobRuntimeRepository, jobRuntime);
            JobCoreConfiguration.Builder coreBuilder = JobCoreConfiguration.newBuilder((String)jobRuntime.getJobName(), (String)jobRuntime.getJobCron(), (int)(jobRuntime.getShardingTotalCount() == null || jobRuntime.getShardingTotalCount() < 1 ? 1 : jobRuntime.getShardingTotalCount())).shardingItemParameters(jobRuntime.getShardingItemParameters()).jobParameter(jobRuntime.getJobParameter()).failover(((Boolean)Objs.defaultIfNull((Object)jobRuntime.getFailover(), (Object)false)).booleanValue()).misfire(((Boolean)Objs.defaultIfNull((Object)jobRuntime.getMisfire(), (Object)true)).booleanValue()).description(jobRuntime.getDescription()).jobProperties(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.getKey(), ((Class)Objs.defaultIfNull(jobRuntime.getExecutorServiceHandlerClass(), DynamicExecutorServiceHandler.class)).getCanonicalName()).jobProperties(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.getKey(), ((Class)Objs.defaultIfNull(jobRuntime.getJobExceptionHandlerClass(), DefaultJobExceptionHandler.class)).getCanonicalName());
            if (Strings.isNotBlank((CharSequence)jobRuntime.getJobAttrs())) {
                try {
                    JSONObject attrs = JSON.parseObject((String)jobRuntime.getJobAttrs());
                    attrs.forEach((k, v) -> coreBuilder.jobProperties(k, Objects.toString(v, null)));
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            JobCoreConfiguration coreConfig = coreBuilder.build();
            SimpleJobConfiguration typeConfig = null;
            Class<?> jobClass = null;
            if (JobType.SIMPLE.equals((Object)jobRuntime.getJobType())) {
                jobClass = jobRuntime.getJobExecutorClass();
                typeConfig = new SimpleJobConfiguration(coreConfig, jobRuntime.getJobExecutor());
            } else if (JobType.DATAFLOW.equals((Object)jobRuntime.getJobType())) {
                jobClass = jobRuntime.getJobExecutorClass();
                typeConfig = new DataflowJobConfiguration(coreConfig, jobRuntime.getJobExecutor(), Boolean.TRUE.equals(jobRuntime.getStreamingProcess()));
            } else if (JobType.SCRIPT.equals((Object)jobRuntime.getJobType())) {
                typeConfig = new ScriptJobConfiguration(coreConfig, jobRuntime.getJobExecutor());
            } else {
                throw new JobException("\u4f5c\u4e1a\u7c7b\u578b\u914d\u7f6e\u6709\u8bef");
            }
            LiteJobConfiguration liteJobConfig = LiteJobConfiguration.newBuilder((JobTypeConfiguration)typeConfig).disabled(((Boolean)Objs.defaultIfNull((Object)jobRuntime.getDisabled(), (Object)false)).booleanValue()).overwrite(((Boolean)Objs.defaultIfNull((Object)jobRuntime.getOverwrite(), (Object)true)).booleanValue()).jobShardingStrategyClass(((Class)Objs.defaultIfNull(jobRuntime.getJobShardingStrategyClass(), DEFAULT_JOB_SHARDING_STRATEGY)).getCanonicalName()).monitorExecution(((Boolean)Objs.defaultIfNull((Object)jobRuntime.getMonitorExecution(), (Object)true)).booleanValue()).maxTimeDiffSeconds(((Integer)Objs.defaultIfNull((Object)jobRuntime.getMaxTimeDiffSeconds(), (Object)-1)).intValue()).monitorPort(((Integer)Objs.defaultIfNull((Object)jobRuntime.getMonitorPort(), (Object)-1)).intValue()).reconcileIntervalMinutes(((Integer)Objs.defaultIfNull((Object)jobRuntime.getReconcileIntervalMinutes(), (Object)10)).intValue()).build();
            if (jobClass != null) {
                try {
                    ElasticJob bean = (ElasticJob)this.context.getBean(jobClass);
                    jobScheduler = new SpringJobScheduler(bean, (CoordinatorRegistryCenter)this.elasticInstance.getRegCenter(), liteJobConfig, this.jobEventConfig, new ElasticJobListener[]{elasticJobListener});
                }
                catch (Throwable e) {
                    log.debug(e.getMessage(), e);
                    jobScheduler = new JobScheduler((CoordinatorRegistryCenter)this.elasticInstance.getRegCenter(), liteJobConfig, this.jobEventConfig, new ElasticJobListener[]{elasticJobListener});
                }
            } else {
                jobScheduler = new JobScheduler((CoordinatorRegistryCenter)this.elasticInstance.getRegCenter(), liteJobConfig, this.jobEventConfig, new ElasticJobListener[]{elasticJobListener});
            }
            try {
                jobScheduler.init();
            }
            catch (Exception e) {
                log.warn("\u6dfb\u52a0\u4f5c\u4e1a\u8c03\u5ea6\u5931\u8d25.\u5c1d\u8bd5\u91cd\u65b0\u914d\u7f6e.\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
                JobSettings jobSettings = new JobSettings();
                jobSettings.setJobName(liteJobConfig.getJobName());
                jobSettings.setJobType(liteJobConfig.getTypeConfig().getJobType().name());
                jobSettings.setJobClass(liteJobConfig.getTypeConfig().getJobClass());
                jobSettings.setCron(coreConfig.getCron());
                jobSettings.setShardingTotalCount(coreConfig.getShardingTotalCount());
                jobSettings.setShardingItemParameters(coreConfig.getShardingItemParameters());
                jobSettings.setJobParameter(coreConfig.getJobParameter());
                jobSettings.setMonitorExecution(liteJobConfig.isMonitorExecution());
                if (typeConfig instanceof DataflowJobConfiguration) {
                    jobSettings.setStreamingProcess(((DataflowJobConfiguration)typeConfig).isStreamingProcess());
                } else {
                    jobSettings.setStreamingProcess(false);
                }
                jobSettings.setMaxTimeDiffSeconds(liteJobConfig.getMaxTimeDiffSeconds());
                jobSettings.setMonitorPort(liteJobConfig.getMonitorPort());
                jobSettings.setFailover(coreConfig.isFailover());
                jobSettings.setMisfire(coreConfig.isMisfire());
                jobSettings.setJobShardingStrategyClass(liteJobConfig.getJobShardingStrategyClass());
                jobSettings.setDescription(coreConfig.getDescription());
                for (JobProperties.JobPropertiesEnum jobPropertiesEnum : JobProperties.JobPropertiesEnum.values()) {
                    String val = coreConfig.getJobProperties().get(jobPropertiesEnum);
                    if (val == null) continue;
                    jobSettings.getJobProperties().put(jobPropertiesEnum.getKey(), val);
                }
                if (typeConfig instanceof ScriptJobConfiguration) {
                    jobSettings.setScriptCommandLine(((ScriptJobConfiguration)typeConfig).getScriptCommandLine());
                }
                jobSettings.setReconcileIntervalMinutes(liteJobConfig.getReconcileIntervalMinutes());
                this.elasticInstance.getJobApi().getJobSettingsApi().updateJobSettings(jobSettings);
                jobScheduler.init();
            }
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), e);
        }
    }

    public void shutdownJob(String jobName) {
        JobRuntimeEntity jobRuntime = this.jobs.get(jobName);
        if (jobRuntime == null) {
            throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u4e0d\u5b58\u5728: " + jobName);
        }
        boolean shardingEnabled = Boolean.TRUE.equals(jobRuntime.getShardingEnabled());
        if (shardingEnabled) {
            this.getJobApi().getJobOperatorApi().shutdown(Optional.of((Object)jobName), Optional.absent());
        } else {
            try {
                this.defaultInstance.getScheduler().deleteJob(this.defaultInstance.jobKey(jobName));
            }
            catch (SchedulerException e) {
                throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u505c\u6b62\u5931\u8d25: " + jobName, e);
            }
        }
        this.doUpdateJobState(jobRuntime, JobState.TERMINATED, "\u5173\u95ed\u4f5c\u4e1a\u8c03\u5ea6");
    }

    public void triggerJob(String jobName) {
        JobRuntimeEntity jobRuntime = this.jobs.get(jobName);
        if (jobRuntime == null) {
            throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u4e0d\u5b58\u5728: " + jobName);
        }
        boolean shardingEnabled = Boolean.TRUE.equals(jobRuntime.getShardingEnabled());
        if (shardingEnabled) {
            this.getJobApi().getJobOperatorApi().trigger(Optional.of((Object)jobName), Optional.absent());
        } else {
            try {
                this.defaultInstance.getScheduler().triggerJob(this.defaultInstance.jobKey(jobName));
            }
            catch (SchedulerException e) {
                throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u505c\u6b62\u5931\u8d25: " + jobName, e);
            }
        }
        this.doUpdateJobState(jobRuntime, JobState.RUNNING, "\u89e6\u53d1\u4f5c\u4e1a\u7acb\u523b\u6267\u884c");
    }

    public void disableJob(String jobName) {
        JobRuntimeEntity jobRuntime = this.jobs.get(jobName);
        if (jobRuntime == null) {
            throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u4e0d\u5b58\u5728: " + jobName);
        }
        boolean shardingEnabled = Boolean.TRUE.equals(jobRuntime.getShardingEnabled());
        if (shardingEnabled) {
            this.getJobApi().getJobOperatorApi().disable(Optional.of((Object)jobName), Optional.absent());
        } else {
            try {
                this.defaultInstance.getScheduler().deleteJob(this.defaultInstance.jobKey(jobName));
            }
            catch (SchedulerException e) {
                throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u505c\u6b62\u5931\u8d25: " + jobName, e);
            }
        }
        this.doUpdateJobState(jobRuntime, JobState.TERMINATED, "\u7981\u7528\u4f5c\u4e1a");
    }

    public void enableJob(String jobName) {
        JobRuntimeEntity jobRuntime = this.jobs.get(jobName);
        if (jobRuntime == null) {
            throw new JobException("\u4f5c\u4e1a\u8c03\u5ea6\u4e0d\u5b58\u5728: " + jobName);
        }
        boolean shardingEnabled = Boolean.TRUE.equals(jobRuntime.getShardingEnabled());
        if (shardingEnabled) {
            this.getJobApi().getJobOperatorApi().enable(Optional.of((Object)jobName), Optional.absent());
        } else {
            this.scheduleJob(jobRuntime);
        }
        this.doUpdateJobState(jobRuntime, jobRuntime.getJobState() != JobState.TERMINATED ? jobRuntime.getJobState() : JobState.RUNNING, "\u542f\u7528\u4f5c\u4e1a");
    }

    public JobScheduleController getJobScheduleController(String jobName) {
        return JobRegistry.getInstance().getJobScheduleController(jobName);
    }

    public JobApi getJobApi() {
        return this.elasticInstance.getJobApi();
    }

    public Scheduler getDefaultScheduler() {
        return this.defaultInstance.getScheduler();
    }

    public boolean isEnabledRdbEvent() {
        return this.enabledRdbEvent;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public JobRuntimeRepository getJobRuntimeRepository() {
        return this.jobRuntimeRepository;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getSysId() {
        return this.sysId;
    }

    public String getVmProcessUid() {
        return this.vmProcessUid;
    }

    public long getVmStartTime() {
        return this.vmStartTime;
    }
}

