/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.context;

import com.dangdang.ddframe.job.lite.lifecycle.api.JobAPIFactory;
import com.dangdang.ddframe.job.lite.lifecycle.api.JobOperateAPI;
import com.dangdang.ddframe.job.lite.lifecycle.api.JobSettingsAPI;
import com.dangdang.ddframe.job.lite.lifecycle.api.JobStatisticsAPI;
import com.dangdang.ddframe.job.lite.lifecycle.api.ServerStatisticsAPI;
import com.dangdang.ddframe.job.lite.lifecycle.api.ShardingOperateAPI;
import com.dangdang.ddframe.job.lite.lifecycle.api.ShardingStatisticsAPI;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.google.common.base.Optional;
import io.polaris.framework.toolkit.elasticjob.context.JobApi;

public class JobApiImpl
implements JobApi {
    private final String connectString;
    private final String namespace;
    private final String digest;

    public JobApiImpl(ZookeeperConfiguration zkConfig) {
        this(zkConfig.getServerLists(), zkConfig.getNamespace(), zkConfig.getDigest());
    }

    public JobApiImpl(String connectString, String namespace, String digest) {
        this.connectString = connectString;
        this.namespace = namespace;
        this.digest = digest;
    }

    @Override
    public JobSettingsAPI getJobSettingsApi() {
        return JobAPIFactory.createJobSettingsAPI((String)this.connectString, (String)this.namespace, (Optional)Optional.fromNullable((Object)this.digest));
    }

    @Override
    public JobOperateAPI getJobOperatorApi() {
        return JobAPIFactory.createJobOperateAPI((String)this.connectString, (String)this.namespace, (Optional)Optional.fromNullable((Object)this.digest));
    }

    @Override
    public ShardingOperateAPI getShardingOperateApi() {
        return JobAPIFactory.createShardingOperateAPI((String)this.connectString, (String)this.namespace, (Optional)Optional.fromNullable((Object)this.digest));
    }

    @Override
    public JobStatisticsAPI getJobStatisticsApi() {
        return JobAPIFactory.createJobStatisticsAPI((String)this.connectString, (String)this.namespace, (Optional)Optional.fromNullable((Object)this.digest));
    }

    @Override
    public ServerStatisticsAPI getServerStatisticsApi() {
        return JobAPIFactory.createServerStatisticsAPI((String)this.connectString, (String)this.namespace, (Optional)Optional.fromNullable((Object)this.digest));
    }

    @Override
    public ShardingStatisticsAPI getShardingStatisticsApi() {
        return JobAPIFactory.createShardingStatisticsAPI((String)this.connectString, (String)this.namespace, (Optional)Optional.fromNullable((Object)this.digest));
    }
}

