/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.context;

import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import io.polaris.framework.toolkit.elasticjob.context.JobApi;
import io.polaris.framework.toolkit.elasticjob.context.JobApiImpl;
import io.polaris.framework.toolkit.elasticjob.entity.JobEnvEntity;
import io.polaris.framework.toolkit.elasticjob.err.JobException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElasticSchedulerHolder {
    private static final Logger log = LoggerFactory.getLogger(ElasticSchedulerHolder.class);
    private final ZookeeperConfiguration zkConfig;
    private final ZookeeperRegistryCenter regCenter;
    private final JobApi jobApi;

    public ElasticSchedulerHolder(ZookeeperRegistryCenter regCenter, ZookeeperConfiguration zkConfig) {
        this.zkConfig = zkConfig;
        this.regCenter = regCenter;
        CuratorFramework client = regCenter.getClient();
        if (client == null || client.getState() != CuratorFrameworkState.STARTED) {
            regCenter.init();
        }
        this.jobApi = new JobApiImpl(zkConfig);
    }

    public ElasticSchedulerHolder(JobEnvEntity jobEnv, DataSource dataSource) {
        try {
            String zkJobNamespace = jobEnv.getZkJobNamespace();
            if (zkJobNamespace != null) {
                zkJobNamespace = zkJobNamespace.replaceFirst("^/+", "");
            }
            ZookeeperConfiguration zkConfig = new ZookeeperConfiguration(jobEnv.getZkAddress(), zkJobNamespace);
            if (jobEnv.getBaseSleepTime() != null && jobEnv.getBaseSleepTime() > 0) {
                zkConfig.setBaseSleepTimeMilliseconds(jobEnv.getBaseSleepTime().intValue());
            }
            if (jobEnv.getMaxSleepTime() != null && jobEnv.getMaxSleepTime() > 0) {
                zkConfig.setMaxSleepTimeMilliseconds(jobEnv.getMaxSleepTime().intValue());
            }
            if (jobEnv.getMaxRetries() != null && jobEnv.getMaxRetries() > 0) {
                zkConfig.setMaxRetries(jobEnv.getMaxRetries().intValue());
            }
            if (jobEnv.getSessionTimeout() != null && jobEnv.getSessionTimeout() > 0) {
                zkConfig.setSessionTimeoutMilliseconds(jobEnv.getSessionTimeout().intValue());
            }
            if (jobEnv.getConnectionTimeout() != null && jobEnv.getConnectionTimeout() > 0) {
                zkConfig.setConnectionTimeoutMilliseconds(jobEnv.getConnectionTimeout().intValue());
            }
            if (StringUtils.isNotBlank((CharSequence)jobEnv.getDigest())) {
                zkConfig.setDigest(jobEnv.getDigest());
            }
            ZookeeperRegistryCenter regCenter = new ZookeeperRegistryCenter(zkConfig);
            regCenter.init();
            this.zkConfig = zkConfig;
            this.regCenter = regCenter;
            this.jobApi = new JobApiImpl(zkConfig);
        }
        catch (Exception e) {
            throw new JobException("\u542f\u52a8\u5206\u7247\u5b9a\u65f6\u4f5c\u4e1a\u8c03\u5ea6\u5668\u5931\u8d25", e);
        }
    }

    public void close() {
        try {
            this.regCenter.close();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public ZookeeperConfiguration getZkConfig() {
        return this.zkConfig;
    }

    public ZookeeperRegistryCenter getRegCenter() {
        return this.regCenter;
    }

    public JobApi getJobApi() {
        return this.jobApi;
    }
}

