/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.context;

import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import io.polaris.framework.toolkit.elasticjob.context.JobState;
import io.polaris.framework.toolkit.elasticjob.entity.JobRuntimeEntity;
import io.polaris.framework.toolkit.elasticjob.repository.JobRuntimeRepository;
import java.util.Date;
import java.util.Map;

class ElasticJobListenerImpl
implements ElasticJobListener {
    private final JobRuntimeRepository jobRuntimeRepository;
    private final JobRuntimeEntity job;

    public ElasticJobListenerImpl(JobRuntimeRepository jobRuntimeRepository, JobRuntimeEntity job) {
        this.jobRuntimeRepository = jobRuntimeRepository;
        this.job = job;
    }

    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        Map shardingItemParameters = shardingContexts.getShardingItemParameters();
        String shardingItems = shardingItemParameters.keySet().toString();
        this.job.setBeginTime(new Date());
        this.job.setEndTime(null);
        this.job.setJobState(JobState.RUNNING);
        this.job.setShardingItems(shardingItems);
        Thread currentThread = Thread.currentThread();
        this.job.setVmThreadId(String.valueOf(currentThread.getId()));
        this.job.setVmThreadName(currentThread.getName());
        this.job.setUptDt(new Date());
        this.jobRuntimeRepository.updateJobStateAndShardingItems(this.job);
    }

    public void afterJobExecuted(ShardingContexts shardingContexts) {
        Map shardingItemParameters = shardingContexts.getShardingItemParameters();
        String shardingItems = shardingItemParameters.keySet().toString();
        this.job.setEndTime(new Date());
        this.job.setJobState(JobState.SUCCESS);
        this.job.setShardingItems(shardingItems);
        Thread currentThread = Thread.currentThread();
        this.job.setVmThreadId(String.valueOf(currentThread.getId()));
        this.job.setVmThreadName(currentThread.getName());
        this.job.setUptDt(new Date());
        this.jobRuntimeRepository.updateJobStateAndShardingItems(this.job);
    }
}

