/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.context;

import io.polaris.framework.toolkit.elasticjob.err.JobException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSchedulerHolder {
    private static final Logger log = LoggerFactory.getLogger(DefaultSchedulerHolder.class);
    private Scheduler scheduler;

    public DefaultSchedulerHolder() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new JobException(e.getMessage(), e);
        }
    }

    public JobKey jobKey(String jobName) {
        return JobKey.jobKey((String)jobName, (String)"DEFAULT");
    }

    public void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

