/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.base;

import io.polaris.framework.toolkit.elasticjob.context.JobCtx;
import io.polaris.framework.toolkit.elasticjob.context.JobCtxHolder;
import io.polaris.framework.toolkit.elasticjob.context.JobState;
import io.polaris.framework.toolkit.elasticjob.entity.JobRuntimeEntity;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public class QuartzJobDelegate
implements Job {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobDelegate.class);
    public static final String DELEGATE_CLASSNAME = "delegateClassname";
    public static final String JOB_RUNTIME_ID = "jobRuntimeId";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        JobCtx jobCtx = JobCtxHolder.get();
        JobRuntimeEntity jobRuntime = null;
        String jobRuntimeId = jobDataMap.getString(JOB_RUNTIME_ID);
        if (jobCtx != null && StringUtils.isNotBlank((CharSequence)jobRuntimeId)) {
            jobRuntime = jobCtx.getJobRuntimeRepository().getJobRuntime(jobRuntimeId);
        }
        Job delegate = null;
        try {
            String delegateExecutorClassname = jobDataMap.getString(DELEGATE_CLASSNAME);
            Class<?> delegateExecutorClass = Class.forName(delegateExecutorClassname);
            delegate = (Job)delegateExecutorClass.newInstance();
            this.doBefore(jobCtx, jobRuntime);
            delegate.execute(context);
            this.doSuccess(jobCtx, jobRuntime);
        }
        catch (Exception e) {
            log.error("\u4f5c\u4e1a\u6267\u884c\u5931\u8d25!" + e.getMessage(), (Throwable)e);
            this.doError(jobCtx, jobRuntime, e);
            throw new JobExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void doBefore(JobCtx jobCtx, JobRuntimeEntity job) {
        if (jobCtx != null && job != null) {
            job.setBeginTime(new Date());
            job.setEndTime(null);
            job.setJobState(JobState.RUNNING);
            job.setShardingItems(null);
            Thread currentThread = Thread.currentThread();
            job.setVmThreadId(String.valueOf(currentThread.getId()));
            job.setVmThreadName(currentThread.getName());
            job.setUptDt(new Date());
            jobCtx.getJobRuntimeRepository().updateJobStateAndShardingItems(job);
        }
    }

    private void doSuccess(JobCtx jobCtx, JobRuntimeEntity job) {
        if (jobCtx != null && job != null) {
            job.setEndTime(new Date());
            job.setJobState(JobState.SUCCESS);
            job.setShardingItems(null);
            Thread currentThread = Thread.currentThread();
            job.setVmThreadId(String.valueOf(currentThread.getId()));
            job.setVmThreadName(currentThread.getName());
            job.setUptDt(new Date());
            jobCtx.getJobRuntimeRepository().updateJobStateAndShardingItems(job);
        }
    }

    private void doError(JobCtx jobCtx, JobRuntimeEntity job, Exception e) {
        if (jobCtx != null && job != null) {
            job.setEndTime(new Date());
            job.setJobState(JobState.ERROR);
            job.setMessage(e.getMessage());
            job.setStackTrace(ExceptionUtils.getStackTrace((Throwable)e));
            job.setShardingItems(null);
            Thread currentThread = Thread.currentThread();
            job.setVmThreadId(String.valueOf(currentThread.getId()));
            job.setVmThreadName(currentThread.getName());
            job.setUptDt(new Date());
            jobCtx.getJobRuntimeRepository().updateJobStateAndShardingItems(job);
        }
    }
}

