/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.base;

import com.dangdang.ddframe.job.api.ShardingContext;
import io.polaris.core.concurrent.pool.WorkerPoolExecutor;
import io.polaris.framework.toolkit.elasticjob.err.JobSkipException;
import java.io.Closeable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(PooledJobExecutor.class);
    private int poolSize = WorkerPoolExecutor.CORE_NUM;
    private int maximumPoolSize = WorkerPoolExecutor.CORE_NUM * 8;
    private long interval = 100L;
    private Consumer<StatisticsInfo> statisticsPersistedDao;
    private ShardingContext shardingContext;
    private WorkerPoolExecutor pool;
    private StatisticsTask statisticsTask;
    private Closeable attachment;
    private StatisticsInfo statisticsInfo;

    public PooledJobExecutor(ShardingContext shardingContext) {
        this.shardingContext = shardingContext;
    }

    public Closeable attachment() {
        return this.attachment;
    }

    public void attachment(Closeable attachment) {
        this.attachment = attachment;
    }

    public void doInit() {
        this.pool = new WorkerPoolExecutor(this.poolSize, this.maximumPoolSize);
        this.statisticsTask = new StatisticsTask();
        log.info("\u542f\u52a8\u7edf\u8ba1\u4f5c\u4e1a\u7ebf\u7a0b");
        this.pool.execute((Runnable)this.statisticsTask);
    }

    public void close() {
        if (this.statisticsTask != null) {
            while (!this.statisticsTask.isTaskFinished()) {
                long timeout = this.interval > 0L ? this.interval : 100L;
                try {
                    log.debug("\u4f5c\u4e1a\u672a\u5b8c\u6210, \u9700\u8981\u7b49\u5f85");
                    TimeUnit.MILLISECONDS.sleep(timeout);
                }
                catch (InterruptedException e) {
                    log.warn("", (Throwable)e);
                }
            }
        }
        try {
            if (this.attachment != null) {
                this.attachment.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closePool();
    }

    private void closePool() {
        if (this.pool != null) {
            WorkerPoolExecutor workerPool = this.pool;
            this.pool = null;
            try {
                workerPool.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!workerPool.isShutdown()) {
                workerPool.shutdownNow();
                if (!workerPool.isShutdown()) {
                    workerPool.shutdown();
                }
            }
            log.info("\u5173\u95ed\u7ebf\u7a0b\u6c60\u5b8c\u6210");
        }
    }

    public void notifyFetched(int count) {
        if (this.statisticsTask != null) {
            this.statisticsTask.notifyFetched(count);
        }
    }

    public boolean execute(Runnable runnable) {
        return this.execute(runnable, 100L, TimeUnit.MILLISECONDS, -1);
    }

    public boolean execute(Runnable runnable, long timeout, TimeUnit timeUnit, int tryTimes) {
        boolean executed = false;
        if (this.pool != null) {
            Runnable delegate = () -> {
                try {
                    runnable.run();
                    this.statisticsTask.notifyFinished(true);
                }
                catch (JobSkipException e) {
                    log.warn(e.getMessage());
                    this.statisticsTask.notifyFinished(true);
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                    this.statisticsTask.notifyFinished(false);
                }
            };
            for (int i = 0; tryTimes <= 0 || i <= tryTimes; ++i) {
                try {
                    this.pool.execute(delegate);
                    log.debug("\u4f5c\u4e1a\u5165\u6c60\u6210\u529f");
                    executed = true;
                    break;
                }
                catch (RejectedExecutionException e) {
                    try {
                        timeUnit.sleep(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (i <= 0) continue;
                    log.debug("\u4f5c\u4e1a\u5165\u6c60\u5931\u8d25, \u7b2c{}\u6b21\u91cd\u8bd5", (Object)i);
                    continue;
                }
            }
        }
        return executed;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setStatisticsPersistedDao(Consumer<StatisticsInfo> statisticsPersistedDao) {
        this.statisticsPersistedDao = statisticsPersistedDao;
    }

    public Consumer<StatisticsInfo> getStatisticsPersistedDao() {
        return this.statisticsPersistedDao;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }

    public StatisticsInfo getStatisticsInfo() {
        return this.statisticsInfo;
    }

    class StatisticsTask
    implements Runnable {
        public static final int INITIAL_VALUE = 0;
        private volatile boolean fetching = true;
        private AtomicLong dataTotal = new AtomicLong(0L);
        private AtomicLong dataFinished = new AtomicLong(0L);
        private AtomicLong dataSuccess = new AtomicLong(0L);
        private volatile boolean taskFinished = false;

        StatisticsTask() {
        }

        @Override
        public void run() {
            this.taskFinished = false;
            long total = 0L;
            long finished = 0L;
            long success = 0L;
            log.info("[\u4f5c\u4e1a:{}, \u5206\u7247:{}] \u4fe1\u606f\u7edf\u8ba1\u5f00\u59cb. total: {}, finished: {}, success: {}", new Object[]{PooledJobExecutor.this.shardingContext.getJobName(), PooledJobExecutor.this.shardingContext.getShardingItem(), total, finished, success});
            while (this.fetching || finished < total) {
                if (total < this.dataTotal.get() || finished < this.dataFinished.get() || success < this.dataSuccess.get()) {
                    try {
                        log.info("[\u4f5c\u4e1a:{}, \u5206\u7247:{}] \u4fe1\u606f\u7edf\u8ba1. total: {}, finished: {}, success: {}", new Object[]{PooledJobExecutor.this.shardingContext.getJobName(), PooledJobExecutor.this.shardingContext.getShardingItem(), total, finished, success});
                        if (PooledJobExecutor.this.statisticsPersistedDao != null) {
                            StatisticsInfo statisticsInfo = StatisticsInfo.builder().dataTotal(this.dataTotal.get()).dataFinished(this.dataFinished.get()).dataSuccess(this.dataSuccess.get()).shardingContext(PooledJobExecutor.this.shardingContext).build();
                            PooledJobExecutor.this.statisticsInfo = statisticsInfo;
                            PooledJobExecutor.this.statisticsPersistedDao.accept(statisticsInfo);
                        }
                    }
                    catch (Throwable e) {
                        log.error("[\u4f5c\u4e1a:{}, \u5206\u7247:{}] \u66f4\u65b0\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25", e);
                    }
                }
                long timeout = PooledJobExecutor.this.interval > 0L ? PooledJobExecutor.this.interval : 100L;
                try {
                    TimeUnit.MILLISECONDS.sleep(timeout);
                }
                catch (InterruptedException e) {
                    log.warn("", (Throwable)e);
                }
            }
            if (PooledJobExecutor.this.statisticsPersistedDao != null) {
                StatisticsInfo statisticsInfo = StatisticsInfo.builder().dataTotal(this.dataTotal.get()).dataFinished(this.dataFinished.get()).dataSuccess(this.dataSuccess.get()).shardingContext(PooledJobExecutor.this.shardingContext).build();
                PooledJobExecutor.this.statisticsInfo = statisticsInfo;
                PooledJobExecutor.this.statisticsPersistedDao.accept(statisticsInfo);
            }
            log.info("[\u4f5c\u4e1a:{}, \u5206\u7247:{}] \u4fe1\u606f\u7edf\u8ba1\u5b8c\u6210. total: {}, finished: {}, success: {}", new Object[]{PooledJobExecutor.this.shardingContext.getJobName(), PooledJobExecutor.this.shardingContext.getShardingItem(), this.dataTotal.get(), this.dataFinished.get(), this.dataSuccess.get()});
            this.taskFinished = true;
        }

        public boolean isTaskFinished() {
            return this.taskFinished;
        }

        public void notifyFetched(int count) {
            if (count > 0) {
                this.dataTotal.getAndAdd(count);
            } else {
                this.fetching = false;
            }
        }

        public void notifyFinished(boolean success) {
            this.notifyFinished(success, 1);
        }

        public void notifyFinished(boolean success, int count) {
            this.dataFinished.getAndAdd(count);
            if (success) {
                this.dataSuccess.getAndAdd(count);
            }
        }
    }

    public static final class StatisticsInfo {
        private final ShardingContext shardingContext;
        private final long dataTotal;
        private final long dataFinished;
        private final long dataSuccess;

        StatisticsInfo(ShardingContext shardingContext, long dataTotal, long dataFinished, long dataSuccess) {
            this.shardingContext = shardingContext;
            this.dataTotal = dataTotal;
            this.dataFinished = dataFinished;
            this.dataSuccess = dataSuccess;
        }

        public static StatisticsInfoBuilder builder() {
            return new StatisticsInfoBuilder();
        }

        public ShardingContext getShardingContext() {
            return this.shardingContext;
        }

        public long getDataTotal() {
            return this.dataTotal;
        }

        public long getDataFinished() {
            return this.dataFinished;
        }

        public long getDataSuccess() {
            return this.dataSuccess;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatisticsInfo)) {
                return false;
            }
            StatisticsInfo other = (StatisticsInfo)o;
            if (this.dataTotal != other.dataTotal) {
                return false;
            }
            if (this.dataFinished != other.dataFinished) {
                return false;
            }
            if (this.dataSuccess != other.dataSuccess) {
                return false;
            }
            ShardingContext this$shardingContext = this.shardingContext;
            ShardingContext other$shardingContext = other.shardingContext;
            return !(this$shardingContext == null ? other$shardingContext != null : !this$shardingContext.equals(other$shardingContext));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $dataTotal = this.dataTotal;
            result = result * 59 + (int)($dataTotal >>> 32 ^ $dataTotal);
            long $dataFinished = this.dataFinished;
            result = result * 59 + (int)($dataFinished >>> 32 ^ $dataFinished);
            long $dataSuccess = this.dataSuccess;
            result = result * 59 + (int)($dataSuccess >>> 32 ^ $dataSuccess);
            ShardingContext $shardingContext = this.shardingContext;
            result = result * 59 + ($shardingContext == null ? 43 : $shardingContext.hashCode());
            return result;
        }

        public String toString() {
            return "PooledJobExecutor.StatisticsInfo(shardingContext=" + this.shardingContext + ", dataTotal=" + this.dataTotal + ", dataFinished=" + this.dataFinished + ", dataSuccess=" + this.dataSuccess + ")";
        }

        public static class StatisticsInfoBuilder {
            private ShardingContext shardingContext;
            private long dataTotal;
            private long dataFinished;
            private long dataSuccess;

            StatisticsInfoBuilder() {
            }

            public StatisticsInfoBuilder shardingContext(ShardingContext shardingContext) {
                this.shardingContext = shardingContext;
                return this;
            }

            public StatisticsInfoBuilder dataTotal(long dataTotal) {
                this.dataTotal = dataTotal;
                return this;
            }

            public StatisticsInfoBuilder dataFinished(long dataFinished) {
                this.dataFinished = dataFinished;
                return this;
            }

            public StatisticsInfoBuilder dataSuccess(long dataSuccess) {
                this.dataSuccess = dataSuccess;
                return this;
            }

            public StatisticsInfo build() {
                return new StatisticsInfo(this.shardingContext, this.dataTotal, this.dataFinished, this.dataSuccess);
            }

            public String toString() {
                return "PooledJobExecutor.StatisticsInfo.StatisticsInfoBuilder(shardingContext=" + this.shardingContext + ", dataTotal=" + this.dataTotal + ", dataFinished=" + this.dataFinished + ", dataSuccess=" + this.dataSuccess + ")";
            }
        }
    }
}

