/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.base;

import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import io.polaris.framework.toolkit.elasticjob.base.PooledJobExecutor;
import io.polaris.framework.toolkit.elasticjob.err.JobException;
import io.polaris.framework.toolkit.elasticjob.err.JobSkipException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePooledJob<T>
implements SimpleJob {
    private static final Logger log = LoggerFactory.getLogger(BasePooledJob.class);

    protected void doBefore(PooledJobExecutor jobExecutor, ShardingContext shardingContext) {
        jobExecutor.setInterval(2000L);
    }

    protected List<T> doFetchData(ShardingContext shardingContext) {
        return null;
    }

    protected List<T> doFetchData(PooledJobExecutor jobExecutor, ShardingContext shardingContext) {
        return this.doFetchData(shardingContext);
    }

    protected void doProcessData(ShardingContext shardingContext, T data) {
    }

    protected void doProcessData(PooledJobExecutor jobExecutor, ShardingContext shardingContext, T data) {
        this.doProcessData(shardingContext, data);
    }

    protected void doAfter(PooledJobExecutor jobExecutor, ShardingContext shardingContext) {
        jobExecutor.close();
    }

    protected void saveJobStatistics(PooledJobExecutor.StatisticsInfo statisticsInfo) {
        log.info("\u4fdd\u5b58\u4f5c\u4e1a\u7edf\u8ba1\u4fe1\u606f: {}", (Object)statisticsInfo);
    }

    public void execute(ShardingContext shardingContext) {
        PooledJobExecutor jobExecutor = new PooledJobExecutor(shardingContext);
        try {
            this.doBefore(jobExecutor, shardingContext);
            jobExecutor.setStatisticsPersistedDao(this::saveJobStatistics);
            jobExecutor.doInit();
            List<T> list = this.doFetchData(jobExecutor, shardingContext);
            if (list == null || list.isEmpty()) {
                log.info("[\u4f5c\u4e1a:{}, \u5206\u7247:{}] \u5f85\u5904\u7406\u6570\u636e\u5168\u90e8\u5904\u7406\u5b8c\u6210.", (Object)shardingContext.getJobName(), (Object)shardingContext.getShardingItem());
                jobExecutor.notifyFetched(0);
            } else {
                while (list != null && !list.isEmpty()) {
                    jobExecutor.notifyFetched(list.size());
                    for (T data : list) {
                        jobExecutor.execute(() -> this.doProcessData(jobExecutor, shardingContext, data));
                    }
                    list = this.doFetchData(jobExecutor, shardingContext);
                }
                log.info("[\u4f5c\u4e1a:{}, \u5206\u7247:{}] \u5f85\u5904\u7406\u6570\u636e\u5168\u90e8\u5904\u7406\u5b8c\u6210.", (Object)shardingContext.getJobName(), (Object)shardingContext.getShardingItem());
                jobExecutor.notifyFetched(0);
            }
        }
        catch (JobSkipException e) {
            log.warn("[\u4f5c\u4e1a:{}, \u5206\u7247:{}] {}", new Object[]{shardingContext.getJobName(), shardingContext.getShardingItem(), e.getMessage()});
        }
        catch (Throwable e) {
            String message = "[\u4f5c\u4e1a:" + shardingContext.getJobName() + ", \u5206\u7247:" + shardingContext.getShardingItem() + "] \u8fd0\u884c\u5f02\u5e38: " + e.getMessage();
            log.error(message, e);
            throw new JobException(message, e);
        }
        finally {
            this.doAfter(jobExecutor, shardingContext);
        }
    }
}

