/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.crypto;

import io.polaris.framework.toolkit.crypto.CryptoPropertyResolver;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class CryptoPropertySource
extends EnumerablePropertySource<EnvHolder> {
    private static final Logger log = LoggerFactory.getLogger(CryptoPropertySource.class);
    private final ThreadLocal<Boolean> skipKey = new ThreadLocal();
    private final ThreadLocal<Deque<String>> resolvedKeys = new ThreadLocal();
    private CryptoPropertyResolver resolver;

    public CryptoPropertySource(String name, EnvHolder source) {
        super(name, (Object)source);
    }

    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    public String[] getPropertyNames() {
        return this.resolver != null ? this.resolver.cachedKeys() : new String[]{};
    }

    private boolean isResolvingKey(String name) {
        Deque<String> queue = this.resolvedKeys.get();
        return queue != null && queue.contains(name);
    }

    private void pushResolveKey(String name) {
        Deque<String> queue = this.resolvedKeys.get();
        if (queue == null) {
            queue = new ArrayDeque<String>();
            this.resolvedKeys.set(queue);
        }
        queue.offerFirst(name);
    }

    private void pollResolveKey(String name) {
        Deque<String> queue = this.resolvedKeys.get();
        if (Objects.equals(queue.peekFirst(), name)) {
            queue.pollFirst();
        }
        if (queue.isEmpty()) {
            this.resolvedKeys.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        if (this.resolver == null) {
            return null;
        }
        if (this.skipKey.get() != null && this.skipKey.get().booleanValue()) {
            return null;
        }
        String decodeKey = this.resolver.decodeKey(name);
        if (!name.equals(decodeKey)) {
            try {
                this.skipKey.set(true);
                ConfigurableEnvironment env = ((EnvHolder)this.getSource()).environment;
                String string = env.getProperty(decodeKey);
                return string;
            }
            finally {
                this.skipKey.remove();
            }
        }
        if (this.isResolvingKey(name)) {
            return null;
        }
        try {
            this.pushResolveKey(name);
            ConfigurableEnvironment env = ((EnvHolder)this.getSource()).environment;
            String value = env.getProperty(name);
            if (value != null) {
                String string = value = this.resolver.decrypt(this, name, value);
                return string;
            }
            String string = this.resolver.getCachedProperty(name);
            return string;
        }
        finally {
            this.pollResolveKey(name);
        }
    }

    public boolean hasResolver() {
        return this.resolver != null;
    }

    public void bindResolver(CryptoPropertyResolver resolver) {
        if (resolver != null && this.resolver != resolver) {
            log.debug("****** bind resolver: {}", (Object)resolver);
            if (this.resolver != null) {
                resolver.merge(this.resolver);
            }
            this.resolver = resolver;
            this.visitEnumerablePropertySource();
        }
    }

    private void visitEnumerablePropertySource() {
        ConfigurableEnvironment env = ((EnvHolder)this.getSource()).environment;
        MutablePropertySources propertySources = env.getPropertySources();
        for (PropertySource propertySource : propertySources) {
            String[] propertyNames;
            if (propertySource == this || !(propertySource instanceof EnumerablePropertySource) || (propertyNames = ((EnumerablePropertySource)propertySource).getPropertyNames()) == null) continue;
            for (String name : propertyNames) {
                this.getProperty(name);
            }
        }
    }

    public static class EnvHolder {
        ConfigurableEnvironment environment;

        public EnvHolder(ConfigurableEnvironment environment) {
            this.environment = environment;
        }
    }
}

