/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.crypto;

import io.polaris.core.io.IO;
import io.polaris.core.string.Strings;
import io.polaris.framework.toolkit.crypto.CryptoAlgorithm;
import io.polaris.framework.toolkit.crypto.CryptoConfigurationProperties;
import io.polaris.framework.toolkit.crypto.CryptoMatchType;
import io.polaris.framework.toolkit.crypto.CryptoOperationException;
import io.polaris.framework.toolkit.crypto.CryptoPropertySource;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={CryptoConfigurationProperties.class})
public class CryptoPropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(CryptoPropertyResolver.class);
    @Autowired
    private CryptoConfigurationProperties properties;
    private ConcurrentHashMap<String, DecryptedValue> cache = new ConcurrentHashMap();

    public CryptoPropertyResolver(CryptoConfigurationProperties properties) {
        this.properties = properties;
    }

    @PostConstruct
    public void init() {
        String decryptKeyLocation;
        String decryptKey;
        Throwable throwable;
        InputStream in;
        String encryptKeyLocation;
        String encryptKey = this.properties.getEncryptKey();
        if ((encryptKey == null || encryptKey.trim().length() == 0) && (encryptKeyLocation = this.properties.getEncryptKeyLocation()) != null && encryptKeyLocation.trim().length() != 0) {
            try {
                in = IO.getInputStream((String)encryptKeyLocation);
                throwable = null;
                try {
                    this.properties.setEncryptKey(IO.toString((InputStream)in));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new BeanInitializationException("encrypt key file is wrong", (Throwable)e);
            }
        }
        if (((decryptKey = this.properties.getDecryptKey()) == null || decryptKey.trim().length() == 0) && (decryptKeyLocation = this.properties.getDecryptKeyLocation()) != null && decryptKeyLocation.trim().length() != 0) {
            try {
                in = IO.getInputStream((String)decryptKeyLocation);
                throwable = null;
                try {
                    this.properties.setEncryptKey(IO.toString((InputStream)in));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new BeanInitializationException("decrypt key file is wrong", (Throwable)e);
            }
        }
        if (this.properties.getProperty().getPrefix() == null) {
            this.properties.getProperty().setPrefix("");
        }
        if (this.properties.getProperty().getSuffix() == null) {
            this.properties.getProperty().setSuffix("");
        }
        if (this.properties.getProperty().getKeyPrefix() == null) {
            this.properties.getProperty().setKeyPrefix("");
        }
        if (this.properties.getProperty().getKeySuffix() == null) {
            this.properties.getProperty().setKeySuffix("");
        }
        if (this.properties.getProperty().getCacheKeyPrefix() == null) {
            this.properties.getProperty().setCacheKeyPrefix("");
        }
        if (this.properties.getProperty().getCacheKeySuffix() == null) {
            this.properties.getProperty().setCacheKeySuffix("");
        }
    }

    public String decrypt(CryptoPropertySource source, String name, String value) {
        String subValue;
        boolean matchName;
        boolean notMatchValue;
        if (value == null) {
            return value;
        }
        DecryptedValue decryptedValue = this.cache.get(name);
        if (decryptedValue != null && decryptedValue.getEncrypted().equals(value)) {
            return decryptedValue.getDecrypted();
        }
        String prefix = this.properties.getProperty().getPrefix();
        String suffix = this.properties.getProperty().getSuffix();
        List<String> includes = this.properties.getProperty().getIncludes();
        List<String> excludes = this.properties.getProperty().getExcludes();
        boolean matchValueOnly = CryptoMatchType.VALUE_ONLY == this.properties.getProperty().getMatchType();
        boolean bl = notMatchValue = !value.startsWith(prefix) || !value.endsWith(suffix);
        if (notMatchValue && matchValueOnly) {
            return value;
        }
        boolean bl2 = matchName = includes == null || includes.isEmpty() || includes.stream().anyMatch(s -> name.matches((String)s));
        if (matchName && excludes != null && !excludes.isEmpty()) {
            boolean bl3 = matchName = !excludes.stream().anyMatch(s -> name.matches((String)s));
        }
        if (!matchName) {
            return value;
        }
        String keyPrefix = this.properties.getProperty().getKeyPrefix();
        String keySuffix = this.properties.getProperty().getKeySuffix();
        String decryptKey = this.properties.getDecryptKey();
        String keyName = keyPrefix + name + keySuffix;
        Object keyValue = source.getProperty(keyName);
        if (keyValue == null || keyValue.equals("")) {
            if (notMatchValue) {
                return value;
            }
        } else {
            decryptKey = keyValue.toString();
        }
        String string = subValue = notMatchValue ? value : value.substring(prefix.length(), value.length() - suffix.length());
        if (!this.properties.isShowOrigin()) {
            log.info("****** decrypt property: `{}`", (Object)name);
        }
        try {
            CryptoAlgorithm algorithm = this.properties.getAlgorithm();
            String origin = algorithm.getEncryptor().decrypt(decryptKey, subValue);
            if (this.properties.isShowOrigin()) {
                log.info("****** decrypt property: `{}` = `{}` ", (Object)name, (Object)origin);
            }
            this.cache.put(name, new DecryptedValue(value, origin));
            return origin;
        }
        catch (Exception e) {
            if (this.properties.isThrowOnFail()) {
                throw new CryptoOperationException("decrypt property `" + name + "` error!", e);
            }
            log.error("decrypt property `" + name + "` error!", (Throwable)e);
            return value;
        }
    }

    public boolean isEncodedKey(String key) {
        String cacheKeyPrefix = this.properties.getProperty().getCacheKeyPrefix();
        String cacheKeySuffix = this.properties.getProperty().getCacheKeySuffix();
        return (Strings.isNotBlank((CharSequence)cacheKeyPrefix) || Strings.isNotBlank((CharSequence)cacheKeySuffix)) && key.startsWith(cacheKeyPrefix) && key.endsWith(cacheKeySuffix);
    }

    public String decodeKey(String key) {
        String cacheKeyPrefix = this.properties.getProperty().getCacheKeyPrefix();
        String cacheKeySuffix = this.properties.getProperty().getCacheKeySuffix();
        if ((Strings.isNotBlank((CharSequence)cacheKeyPrefix) || Strings.isNotBlank((CharSequence)cacheKeySuffix)) && key.startsWith(cacheKeyPrefix) && key.endsWith(cacheKeySuffix)) {
            return key.substring(cacheKeyPrefix.length(), key.length() - cacheKeySuffix.length());
        }
        return key;
    }

    public String getCachedProperty(String key) {
        String cacheKeyPrefix = this.properties.getProperty().getCacheKeyPrefix();
        String cacheKeySuffix = this.properties.getProperty().getCacheKeySuffix();
        if ((Strings.isNotBlank((CharSequence)cacheKeyPrefix) || Strings.isNotBlank((CharSequence)cacheKeySuffix)) && key.startsWith(cacheKeyPrefix) && key.endsWith(cacheKeySuffix)) {
            String subKey = key.substring(cacheKeyPrefix.length(), key.length() - cacheKeySuffix.length());
            DecryptedValue decryptedValue = this.cache.get(subKey);
            return decryptedValue == null ? null : decryptedValue.getEncrypted();
        }
        DecryptedValue decryptedValue = this.cache.get(key);
        return decryptedValue == null ? null : decryptedValue.getDecrypted();
    }

    public String[] cachedKeys() {
        Set keys = this.cache.keySet();
        if (Strings.isNotBlank((CharSequence)this.properties.getProperty().getCacheKeyPrefix()) || Strings.isNotBlank((CharSequence)this.properties.getProperty().getCacheKeySuffix())) {
            keys = this.cache.keySet().stream().collect(TreeSet::new, (set, key) -> {
                set.add(key);
                set.add(this.properties.getProperty().getCacheKeyPrefix() + key + this.properties.getProperty().getCacheKeySuffix());
            }, TreeSet::addAll);
        }
        return keys.toArray(new String[0]);
    }

    void merge(CryptoPropertyResolver resolver) {
        resolver.cache.forEach((k, v) -> this.cache.putIfAbsent((String)k, (DecryptedValue)v));
    }

    static class DecryptedValue {
        private String encrypted;
        private String decrypted;

        public DecryptedValue(String encrypted, String decrypted) {
            this.encrypted = encrypted;
            this.decrypted = decrypted;
        }

        public String getEncrypted() {
            return this.encrypted;
        }

        public String getDecrypted() {
            return this.decrypted;
        }

        public void setEncrypted(String encrypted) {
            this.encrypted = encrypted;
        }

        public void setDecrypted(String decrypted) {
            this.decrypted = decrypted;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecryptedValue)) {
                return false;
            }
            DecryptedValue other = (DecryptedValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$encrypted = this.encrypted;
            String other$encrypted = other.encrypted;
            if (this$encrypted == null ? other$encrypted != null : !this$encrypted.equals(other$encrypted)) {
                return false;
            }
            String this$decrypted = this.decrypted;
            String other$decrypted = other.decrypted;
            return !(this$decrypted == null ? other$decrypted != null : !this$decrypted.equals(other$decrypted));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DecryptedValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $encrypted = this.encrypted;
            result = result * 59 + ($encrypted == null ? 43 : $encrypted.hashCode());
            String $decrypted = this.decrypted;
            result = result * 59 + ($decrypted == null ? 43 : $decrypted.hashCode());
            return result;
        }

        public String toString() {
            return "CryptoPropertyResolver.DecryptedValue(encrypted=" + this.encrypted + ", decrypted=" + this.decrypted + ")";
        }
    }
}

