/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.crypto;

import io.polaris.framework.core.context.AppCtx;
import io.polaris.framework.core.context.base.Binders;
import io.polaris.framework.toolkit.annotation.EnableCryptoProperties;
import io.polaris.framework.toolkit.crypto.CryptoApplicationContextInitializer;
import io.polaris.framework.toolkit.crypto.CryptoConfigurationProperties;
import io.polaris.framework.toolkit.crypto.CryptoPropertiesBeanFactoryPostProcessor;
import io.polaris.framework.toolkit.crypto.CryptoPropertyResolver;
import io.polaris.framework.toolkit.crypto.CryptoPropertySource;
import java.util.Map;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;

public class CryptoPropertiesBeanHelper {
    public static void determineCryptoCapability(ConfigurableEnvironment environment, SpringApplication springApplication) {
        Boolean enabled = (Boolean)environment.getProperty("platform.crypto.enabled", Boolean.class, (Object)true);
        if (enabled.booleanValue()) {
            CryptoPropertiesBeanHelper.buildEarly(environment);
            springApplication.addInitializers(new ApplicationContextInitializer[]{new CryptoApplicationContextInitializer()});
        }
    }

    public static void buildEarly(ConfigurableEnvironment environment) {
        CryptoPropertySource propertySource = CryptoPropertiesBeanHelper.attachPropertySource(environment);
        if (!propertySource.hasResolver()) {
            CryptoPropertyResolver resolver = CryptoPropertiesBeanHelper.buildResolverEarly(environment);
            propertySource.bindResolver(resolver);
        }
    }

    private static CryptoPropertySource attachPropertySource(ConfigurableEnvironment environment) {
        String name;
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        Object propertySource = mutablePropertySources.get(name = "cryptoProperties");
        if (propertySource != null) {
            mutablePropertySources.remove(name);
            if (!(propertySource instanceof CryptoPropertySource)) {
                propertySource = null;
            }
        }
        if (propertySource == null) {
            propertySource = new CryptoPropertySource(name, new CryptoPropertySource.EnvHolder(environment));
        }
        mutablePropertySources.addFirst(propertySource);
        return (CryptoPropertySource)((Object)propertySource);
    }

    private static CryptoPropertyResolver buildResolverEarly(ConfigurableEnvironment environment) {
        CryptoConfigurationProperties properties = (CryptoConfigurationProperties)Binders.bind((Environment)environment, CryptoConfigurationProperties.class, (String)"platform.crypto");
        if (properties == null) {
            properties = new CryptoConfigurationProperties();
            properties.setEnabled(true);
        }
        CryptoPropertyResolver resolver = new CryptoPropertyResolver(properties);
        resolver.init();
        return resolver;
    }

    public static void buildEarlyInRegistrarIfNecessary(AnnotationMetadata importingClassMetadata) {
        AppCtx.configurableEnvironment().ifPresent(environment -> {
            String name;
            MutablePropertySources mutablePropertySources = environment.getPropertySources();
            PropertySource propertySource = mutablePropertySources.get(name = "cryptoProperties");
            if (propertySource != null) {
                return;
            }
            Boolean enabled = (Boolean)environment.getProperty("platform.crypto.enabled", Boolean.class, (Object)false);
            if (!enabled.booleanValue()) {
                Map attributes = importingClassMetadata.getAnnotationAttributes(EnableCryptoProperties.class.getName(), false);
                enabled = attributes != null;
            }
            if (enabled.booleanValue()) {
                CryptoPropertiesBeanHelper.buildEarly(environment);
            }
        });
    }

    public static CryptoPropertiesBeanFactoryPostProcessor bindInitializer(ConfigurableApplicationContext applicationContext) {
        CryptoPropertiesBeanFactoryPostProcessor postProcessor = new CryptoPropertiesBeanFactoryPostProcessor();
        postProcessor.setApplicationContext(applicationContext);
        applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)postProcessor);
        return postProcessor;
    }

    public static void bindResolver(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        CryptoPropertySource propertySource = CryptoPropertiesBeanHelper.attachPropertySource(environment);
        CryptoPropertyResolver resolver = (CryptoPropertyResolver)applicationContext.getBean(CryptoPropertyResolver.class);
        propertySource.bindResolver(resolver);
    }
}

