/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.crypto;

import io.polaris.framework.toolkit.crypto.CryptoAlgorithm;
import io.polaris.framework.toolkit.crypto.CryptoMatchType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="platform.crypto", ignoreUnknownFields=true)
public class CryptoConfigurationProperties {
    private boolean enabled = false;
    private boolean showOrigin = false;
    private boolean throwOnFail = true;
    private CryptoAlgorithm algorithm = CryptoAlgorithm.RSA;
    private String decryptKey;
    private String decryptKeyLocation;
    private String encryptKey;
    private String encryptKeyLocation;
    @NestedConfigurationProperty
    private EnvConfigurationProperties property = new EnvConfigurationProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isShowOrigin() {
        return this.showOrigin;
    }

    public boolean isThrowOnFail() {
        return this.throwOnFail;
    }

    public CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getDecryptKey() {
        return this.decryptKey;
    }

    public String getDecryptKeyLocation() {
        return this.decryptKeyLocation;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public String getEncryptKeyLocation() {
        return this.encryptKeyLocation;
    }

    public EnvConfigurationProperties getProperty() {
        return this.property;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setShowOrigin(boolean showOrigin) {
        this.showOrigin = showOrigin;
    }

    public void setThrowOnFail(boolean throwOnFail) {
        this.throwOnFail = throwOnFail;
    }

    public void setAlgorithm(CryptoAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setDecryptKey(String decryptKey) {
        this.decryptKey = decryptKey;
    }

    public void setDecryptKeyLocation(String decryptKeyLocation) {
        this.decryptKeyLocation = decryptKeyLocation;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public void setEncryptKeyLocation(String encryptKeyLocation) {
        this.encryptKeyLocation = encryptKeyLocation;
    }

    public void setProperty(EnvConfigurationProperties property) {
        this.property = property;
    }

    public String toString() {
        return "CryptoConfigurationProperties(enabled=" + this.enabled + ", showOrigin=" + this.showOrigin + ", throwOnFail=" + this.throwOnFail + ", algorithm=" + (Object)((Object)this.algorithm) + ", decryptKey=" + this.decryptKey + ", decryptKeyLocation=" + this.decryptKeyLocation + ", encryptKey=" + this.encryptKey + ", encryptKeyLocation=" + this.encryptKeyLocation + ", property=" + this.property + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptoConfigurationProperties)) {
            return false;
        }
        CryptoConfigurationProperties other = (CryptoConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.showOrigin != other.showOrigin) {
            return false;
        }
        if (this.throwOnFail != other.throwOnFail) {
            return false;
        }
        CryptoAlgorithm this$algorithm = this.algorithm;
        CryptoAlgorithm other$algorithm = other.algorithm;
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        String this$decryptKey = this.decryptKey;
        String other$decryptKey = other.decryptKey;
        if (this$decryptKey == null ? other$decryptKey != null : !this$decryptKey.equals(other$decryptKey)) {
            return false;
        }
        String this$decryptKeyLocation = this.decryptKeyLocation;
        String other$decryptKeyLocation = other.decryptKeyLocation;
        if (this$decryptKeyLocation == null ? other$decryptKeyLocation != null : !this$decryptKeyLocation.equals(other$decryptKeyLocation)) {
            return false;
        }
        String this$encryptKey = this.encryptKey;
        String other$encryptKey = other.encryptKey;
        if (this$encryptKey == null ? other$encryptKey != null : !this$encryptKey.equals(other$encryptKey)) {
            return false;
        }
        String this$encryptKeyLocation = this.encryptKeyLocation;
        String other$encryptKeyLocation = other.encryptKeyLocation;
        if (this$encryptKeyLocation == null ? other$encryptKeyLocation != null : !this$encryptKeyLocation.equals(other$encryptKeyLocation)) {
            return false;
        }
        EnvConfigurationProperties this$property = this.property;
        EnvConfigurationProperties other$property = other.property;
        return !(this$property == null ? other$property != null : !((Object)this$property).equals(other$property));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptoConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enabled ? 79 : 97);
        result = result * 59 + (this.showOrigin ? 79 : 97);
        result = result * 59 + (this.throwOnFail ? 79 : 97);
        CryptoAlgorithm $algorithm = this.algorithm;
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        String $decryptKey = this.decryptKey;
        result = result * 59 + ($decryptKey == null ? 43 : $decryptKey.hashCode());
        String $decryptKeyLocation = this.decryptKeyLocation;
        result = result * 59 + ($decryptKeyLocation == null ? 43 : $decryptKeyLocation.hashCode());
        String $encryptKey = this.encryptKey;
        result = result * 59 + ($encryptKey == null ? 43 : $encryptKey.hashCode());
        String $encryptKeyLocation = this.encryptKeyLocation;
        result = result * 59 + ($encryptKeyLocation == null ? 43 : $encryptKeyLocation.hashCode());
        EnvConfigurationProperties $property = this.property;
        result = result * 59 + ($property == null ? 43 : ((Object)$property).hashCode());
        return result;
    }

    public static class EnvConfigurationProperties {
        private CryptoMatchType matchType = CryptoMatchType.VALUE_ONLY;
        private String prefix = "ENC@";
        private String suffix = "";
        private String keyPrefix = "";
        private String keySuffix = "@key";
        private String cacheKeyPrefix = "";
        private String cacheKeySuffix = "@enc";
        private List<String> includes = null;
        private List<String> excludes = new ArrayList<String>(Arrays.asList("^spring\\.toolkit\\.crypto.*"));

        public CryptoMatchType getMatchType() {
            return this.matchType;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getKeyPrefix() {
            return this.keyPrefix;
        }

        public String getKeySuffix() {
            return this.keySuffix;
        }

        public String getCacheKeyPrefix() {
            return this.cacheKeyPrefix;
        }

        public String getCacheKeySuffix() {
            return this.cacheKeySuffix;
        }

        public List<String> getIncludes() {
            return this.includes;
        }

        public List<String> getExcludes() {
            return this.excludes;
        }

        public void setMatchType(CryptoMatchType matchType) {
            this.matchType = matchType;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public void setKeySuffix(String keySuffix) {
            this.keySuffix = keySuffix;
        }

        public void setCacheKeyPrefix(String cacheKeyPrefix) {
            this.cacheKeyPrefix = cacheKeyPrefix;
        }

        public void setCacheKeySuffix(String cacheKeySuffix) {
            this.cacheKeySuffix = cacheKeySuffix;
        }

        public void setIncludes(List<String> includes) {
            this.includes = includes;
        }

        public void setExcludes(List<String> excludes) {
            this.excludes = excludes;
        }

        public String toString() {
            return "CryptoConfigurationProperties.EnvConfigurationProperties(matchType=" + (Object)((Object)this.matchType) + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ", keyPrefix=" + this.keyPrefix + ", keySuffix=" + this.keySuffix + ", cacheKeyPrefix=" + this.cacheKeyPrefix + ", cacheKeySuffix=" + this.cacheKeySuffix + ", includes=" + this.includes + ", excludes=" + this.excludes + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnvConfigurationProperties)) {
                return false;
            }
            EnvConfigurationProperties other = (EnvConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CryptoMatchType this$matchType = this.matchType;
            CryptoMatchType other$matchType = other.matchType;
            if (this$matchType == null ? other$matchType != null : !((Object)((Object)this$matchType)).equals((Object)other$matchType)) {
                return false;
            }
            String this$prefix = this.prefix;
            String other$prefix = other.prefix;
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            String this$suffix = this.suffix;
            String other$suffix = other.suffix;
            if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
                return false;
            }
            String this$keyPrefix = this.keyPrefix;
            String other$keyPrefix = other.keyPrefix;
            if (this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix)) {
                return false;
            }
            String this$keySuffix = this.keySuffix;
            String other$keySuffix = other.keySuffix;
            if (this$keySuffix == null ? other$keySuffix != null : !this$keySuffix.equals(other$keySuffix)) {
                return false;
            }
            String this$cacheKeyPrefix = this.cacheKeyPrefix;
            String other$cacheKeyPrefix = other.cacheKeyPrefix;
            if (this$cacheKeyPrefix == null ? other$cacheKeyPrefix != null : !this$cacheKeyPrefix.equals(other$cacheKeyPrefix)) {
                return false;
            }
            String this$cacheKeySuffix = this.cacheKeySuffix;
            String other$cacheKeySuffix = other.cacheKeySuffix;
            if (this$cacheKeySuffix == null ? other$cacheKeySuffix != null : !this$cacheKeySuffix.equals(other$cacheKeySuffix)) {
                return false;
            }
            List<String> this$includes = this.includes;
            List<String> other$includes = other.includes;
            if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
                return false;
            }
            List<String> this$excludes = this.excludes;
            List<String> other$excludes = other.excludes;
            return !(this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnvConfigurationProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CryptoMatchType $matchType = this.matchType;
            result = result * 59 + ($matchType == null ? 43 : ((Object)((Object)$matchType)).hashCode());
            String $prefix = this.prefix;
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            String $suffix = this.suffix;
            result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
            String $keyPrefix = this.keyPrefix;
            result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
            String $keySuffix = this.keySuffix;
            result = result * 59 + ($keySuffix == null ? 43 : $keySuffix.hashCode());
            String $cacheKeyPrefix = this.cacheKeyPrefix;
            result = result * 59 + ($cacheKeyPrefix == null ? 43 : $cacheKeyPrefix.hashCode());
            String $cacheKeySuffix = this.cacheKeySuffix;
            result = result * 59 + ($cacheKeySuffix == null ? 43 : $cacheKeySuffix.hashCode());
            List<String> $includes = this.includes;
            result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
            List<String> $excludes = this.excludes;
            result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
            return result;
        }
    }
}

