/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.configuration;

import io.polaris.core.string.Strings;
import io.polaris.framework.toolkit.configuration.AbstractDynamicTransactionConfiguration;
import io.polaris.framework.toolkit.support.InheritedAnnotationClassFilter;
import io.polaris.framework.toolkit.transaction.DynamicTransactionProperties;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aspectj.weaver.tools.PointcutParser;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.TypePatternClassFilter;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.ClassFilters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.CompositeTransactionAttributeSource;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.ClassUtils;

@Configuration
@EnableConfigurationProperties(value={DynamicTransactionProperties.class})
public class DynamicProxyTransactionConfiguration
extends AbstractDynamicTransactionConfiguration {
    protected TransactionInterceptor nameMatchTransactionInterceptor;
    protected TransactionInterceptor annotationTransactionInterceptor;
    protected NameMatchTransactionAttributeSource nameMatchTransactionAttributeSource = this.buildNameMatchTxAttrSource();
    protected AnnotationTransactionAttributeSource annotationTransactionAttributeSource = this.buildAnnotationTxAttrSource();

    public DynamicProxyTransactionConfiguration(DynamicTransactionProperties properties, PlatformTransactionManager transactionManager) {
        super(properties, transactionManager);
        this.nameMatchTransactionInterceptor = this.buildInterceptor((TransactionAttributeSource)this.nameMatchTransactionAttributeSource, (TransactionManager)this.transactionManager);
        this.annotationTransactionInterceptor = this.buildInterceptor((TransactionAttributeSource)this.annotationTransactionAttributeSource, (TransactionManager)this.transactionManager);
    }

    @Bean
    public BeanFactoryTransactionAttributeSourceAdvisor txAdvisor() {
        BeanFactoryTransactionAttributeSourceAdvisor advisor = new BeanFactoryTransactionAttributeSourceAdvisor();
        ArrayList<ClassFilter> filters = new ArrayList<ClassFilter>();
        if (Strings.isNotBlank((CharSequence)this.properties.getClassPattern())) {
            this.addClassPatternFilter(filters);
        }
        if (this.enableAspectFilter()) {
            this.addClassFilters(filters);
        }
        if (filters.isEmpty()) {
            filters.add(clazz -> false);
        }
        CompositeTransactionAttributeSource transactionAttributeSource = new CompositeTransactionAttributeSource(new TransactionAttributeSource[]{this.annotationTransactionAttributeSource, this.nameMatchTransactionAttributeSource});
        advisor.setTransactionAttributeSource((TransactionAttributeSource)transactionAttributeSource);
        advisor.setAdvice((Advice)this.buildInterceptor((TransactionAttributeSource)transactionAttributeSource, (TransactionManager)this.transactionManager));
        advisor.setClassFilter(ClassFilters.union((ClassFilter[])filters.toArray(new ClassFilter[0])));
        advisor.setOrder(0x7FFFFF7F);
        return advisor;
    }

    private void addClassPatternFilter(List<ClassFilter> filters) {
        TypePatternClassFilter filter = new TypePatternClassFilter(this.properties.getClassPattern());
        try {
            PointcutParser parser = PointcutParser.getPointcutParserSupportingAllPrimitivesAndUsingContextClassloaderForResolution();
            parser.parsePointcutExpression(this.properties.getClassPattern());
            AspectJExpressionPointcut aspectJExpressionPointcut = new AspectJExpressionPointcut();
            aspectJExpressionPointcut.setExpression(this.properties.getClassPattern());
            filter = ClassFilters.union((ClassFilter)filter, c -> AopUtils.canApply((Pointcut)aspectJExpressionPointcut, (Class)c));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        filters.add((ClassFilter)filter);
    }

    protected boolean enableAspectFilter() {
        return true;
    }

    protected void addClassFilters(List<ClassFilter> filters) {
        if (this.properties.isEnableTransactionalAspect()) {
            filters.add(InheritedAnnotationClassFilter.withClassOrMethodAnnotation(Transactional.class));
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            if (ClassUtils.isPresent((String)"javax.transaction.Transactional", (ClassLoader)classLoader)) {
                Class annotationType = ClassUtils.resolveClassName((String)"javax.transaction.Transactional", (ClassLoader)classLoader);
                filters.add(InheritedAnnotationClassFilter.withClassOrMethodAnnotation(annotationType));
            }
        }
        if (this.properties.isEnableServiceAspect()) {
            filters.add(InheritedAnnotationClassFilter.withClassOrMethodAnnotation(Service.class));
        }
        if (this.properties.isEnableRepositoryAspect()) {
            filters.add(InheritedAnnotationClassFilter.withClassOrMethodAnnotation(Repository.class));
        }
    }
}

