/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.configuration;

import io.polaris.core.string.Strings;
import io.polaris.framework.toolkit.jdbc.DynamicDataSource;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceProperties;
import io.polaris.framework.toolkit.jdbc.properties.TargetDataSourceProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
@Deprecated
public class DynamicDataSourceConfiguration
implements BeanClassLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceConfiguration.class);
    private DynamicDataSourceProperties properties;
    private ClassLoader classLoader;

    public DynamicDataSourceConfiguration(DynamicDataSourceProperties properties) {
        this.properties = properties;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    DataSource asTransactionDelegate(DataSource ds) {
        if (!this.properties.isEnableTransactionDelegate()) {
            return ds;
        }
        return new TransactionAwareDataSourceProxy(ds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Bean
    public DataSource dynamicDataSource() {
        Object dynamicDataSource = null;
        if (!this.properties.isMultiple()) {
            String primaryName;
            TargetDataSourceProperties primary = this.properties.getPrimary();
            if (primary == null && Strings.isNotBlank((CharSequence)(primaryName = this.properties.getPrimaryName()))) {
                primary = this.properties.getTargetDataSourceProperties(primaryName);
            }
            if (primary == null) {
                throw new BeanInitializationException("\u521b\u5efa\u6570\u636e\u6e90\u5b9e\u4f8b\u5931\u8d25\uff01\u672a\u542f\u7528\u591a\u6570\u636e\u6e90\u914d\u7f6e\u4e14\u672a\u914d\u7f6e\u4e3b\u6570\u636e\u6e90\u4fe1\u606f");
            }
            dynamicDataSource = primary.buildDataSource(this.classLoader);
            return this.asTransactionDelegate((DataSource)dynamicDataSource);
        }
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        String defaultTargetDataSource = null;
        TargetDataSourceProperties primary = this.properties.getPrimary();
        Map<String, TargetDataSourceProperties> targets = this.properties.getTargets();
        HashSet<String> keys = new HashSet<String>();
        if (Strings.isNotBlank((CharSequence)this.properties.getPrimaryName())) {
            defaultTargetDataSource = this.properties.getPrimaryName();
            keys.add(defaultTargetDataSource);
            if (!targets.containsKey(defaultTargetDataSource)) {
                if (primary == null) throw new BeanInitializationException("\u521b\u5efa\u6570\u636e\u6e90\u5b9e\u4f8b\u5931\u8d25\uff01\u4e3b\u6570\u636e\u6e90\u914d\u7f6e\u7f3a\u5931");
                targets.put(defaultTargetDataSource, primary);
            }
        } else if (primary != null) {
            defaultTargetDataSource = targets.containsKey("default") ? "default@" + UUID.randomUUID() : "default";
            keys.add(defaultTargetDataSource);
            targets.put(defaultTargetDataSource, primary);
        }
        if (this.properties.isEnableAllTargets()) {
            for (Map.Entry<String, TargetDataSourceProperties> entry : targets.entrySet()) {
                String name = entry.getKey();
                DataSource dataSource = entry.getValue().buildDataSource(this.classLoader);
                targetDataSources.put(name, dataSource);
            }
        } else {
            String names = this.properties.getTargetNames();
            if (!Strings.isNotBlank((CharSequence)names)) {
                throw new BeanInitializationException("\u65e0\u6cd5\u521b\u5efa\u591a\u6570\u636e\u6e90\u5b9e\u4f8b\uff01\u672a\u6307\u5b9a\u6570\u636e\u6e90\u540d\u79f0\u5217\u8868");
            }
            String[] nameArray = Strings.tokenizeToArray((String)names, (String)",");
            for (String name : nameArray) {
                keys.add(name);
            }
            for (String name : keys) {
                TargetDataSourceProperties dataSourceProperties = targets.get(name);
                if (dataSourceProperties == null) {
                    throw new BeanInitializationException("\u672a\u914d\u7f6e\u76ee\u6807\u6570\u636e\u6e90\uff1a" + name);
                }
                DataSource dataSource = dataSourceProperties.buildDataSource(this.classLoader);
                targetDataSources.put(name, dataSource);
            }
        }
        dynamicDataSource = new DynamicDataSource(targetDataSources, defaultTargetDataSource, targets);
        return this.asTransactionDelegate((DataSource)dynamicDataSource);
    }
}

