/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.configuration;

import io.polaris.framework.toolkit.configuration.AbstractDynamicTransactionConfiguration;
import io.polaris.framework.toolkit.configuration.DynamicProxyTransactionConfiguration;
import io.polaris.framework.toolkit.transaction.DynamicTransactionProperties;
import io.polaris.framework.toolkit.transaction.JtaTransactionalAspect;
import io.polaris.framework.toolkit.transaction.SpringRepositoryAspect;
import io.polaris.framework.toolkit.transaction.SpringServiceAspect;
import io.polaris.framework.toolkit.transaction.SpringTransactionalAspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@EnableConfigurationProperties(value={DynamicTransactionProperties.class})
public class DynamicAspectTransactionConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={DynamicTransactionProperties.class})
    public static class ProxyTransactionConfig
    extends DynamicProxyTransactionConfiguration {
        public ProxyTransactionConfig(DynamicTransactionProperties properties, PlatformTransactionManager transactionManager) {
            super(properties, transactionManager);
        }

        @Override
        protected boolean enableAspectFilter() {
            return false;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={DynamicTransactionProperties.class})
    public static class SpringRepositoryAspectConfig
    extends AbstractDynamicTransactionConfiguration {
        protected TransactionInterceptor nameMatchTransactionInterceptor;
        protected NameMatchTransactionAttributeSource nameMatchTransactionAttributeSource = this.buildNameMatchTxAttrSource();

        public SpringRepositoryAspectConfig(DynamicTransactionProperties properties, PlatformTransactionManager transactionManager) {
            super(properties, transactionManager);
            this.nameMatchTransactionInterceptor = this.buildInterceptor((TransactionAttributeSource)this.nameMatchTransactionAttributeSource, (TransactionManager)this.transactionManager);
        }

        @Bean
        public SpringRepositoryAspect springRepositoryAspect() {
            return new SpringRepositoryAspect(this.nameMatchTransactionInterceptor);
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={DynamicTransactionProperties.class})
    public static class SpringServiceAspectConfig
    extends AbstractDynamicTransactionConfiguration {
        protected TransactionInterceptor nameMatchTransactionInterceptor;
        protected NameMatchTransactionAttributeSource nameMatchTransactionAttributeSource = this.buildNameMatchTxAttrSource();

        public SpringServiceAspectConfig(DynamicTransactionProperties properties, PlatformTransactionManager transactionManager) {
            super(properties, transactionManager);
            this.nameMatchTransactionInterceptor = this.buildInterceptor((TransactionAttributeSource)this.nameMatchTransactionAttributeSource, (TransactionManager)this.transactionManager);
        }

        @Bean
        public SpringServiceAspect springServiceAspect() {
            return new SpringServiceAspect(this.nameMatchTransactionInterceptor);
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={DynamicTransactionProperties.class})
    public static class TransactionalAspectConfig
    extends AbstractDynamicTransactionConfiguration {
        protected TransactionInterceptor annotationTransactionInterceptor;
        protected AnnotationTransactionAttributeSource annotationTransactionAttributeSource = this.buildAnnotationTxAttrSource();

        public TransactionalAspectConfig(DynamicTransactionProperties properties, PlatformTransactionManager transactionManager) {
            super(properties, transactionManager);
            this.annotationTransactionInterceptor = this.buildInterceptor((TransactionAttributeSource)this.annotationTransactionAttributeSource, (TransactionManager)this.transactionManager);
        }

        @Bean
        @ConditionalOnClass(name={"javax.transaction.Transactional"})
        public JtaTransactionalAspect jtaTransactionalAspect() {
            return new JtaTransactionalAspect(this.annotationTransactionInterceptor);
        }

        @Bean
        public SpringTransactionalAspect springTransactionalAspect() {
            return new SpringTransactionalAspect(this.annotationTransactionInterceptor);
        }
    }
}

