/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.configuration;

import io.polaris.core.string.Strings;
import io.polaris.framework.toolkit.transaction.DynamicTransactionProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.aop.ClassFilter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@EnableConfigurationProperties(value={DynamicTransactionProperties.class})
public abstract class AbstractDynamicTransactionConfiguration
extends AbstractTransactionManagementConfiguration {
    protected DynamicTransactionProperties properties;
    protected PlatformTransactionManager transactionManager;

    public AbstractDynamicTransactionConfiguration(DynamicTransactionProperties properties, PlatformTransactionManager transactionManager) {
        this.properties = properties;
        this.transactionManager = transactionManager;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
    }

    protected TransactionInterceptor buildInterceptor(TransactionAttributeSource source, TransactionManager transactionManager) {
        return new TransactionInterceptor(transactionManager, source);
    }

    protected NameMatchTransactionAttributeSource buildNameMatchTxAttrSource() {
        String[] methods;
        RuleBasedTransactionAttribute attr;
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        String transactionalMethods = this.properties.getReadonlyTransactionalMethods();
        if (Strings.isNotBlank((CharSequence)transactionalMethods)) {
            attr = new RuleBasedTransactionAttribute();
            attr.setPropagationBehavior(0);
            attr.setReadOnly(true);
            this.addRollbackRules(attr, this.properties.getRollbackExceptions(), this.properties.getNoRollbackExceptions());
            for (String method : methods = Strings.tokenizeToArray((String)transactionalMethods, (String)",")) {
                source.addTransactionalMethod(method, (TransactionAttribute)attr);
            }
        }
        if (Strings.isNotBlank((CharSequence)(transactionalMethods = this.properties.getNewTransactionalMethods()))) {
            attr = new RuleBasedTransactionAttribute();
            attr.setPropagationBehavior(3);
            attr.setIsolationLevel(2);
            this.addRollbackRules(attr, this.properties.getRollbackExceptions(), this.properties.getNoRollbackExceptions());
            for (String method : methods = Strings.tokenizeToArray((String)transactionalMethods, (String)",")) {
                source.addTransactionalMethod(method, (TransactionAttribute)attr);
            }
        }
        RuleBasedTransactionAttribute attr2 = new RuleBasedTransactionAttribute();
        attr2.setPropagationBehavior(0);
        attr2.setIsolationLevel(2);
        this.addRollbackRules(attr2, this.properties.getRollbackExceptions(), this.properties.getNoRollbackExceptions());
        String transactionalMethods2 = this.properties.getStdTransactionalMethods();
        if (Strings.isNotBlank((CharSequence)transactionalMethods2)) {
            for (String method : methods = Strings.tokenizeToArray((String)transactionalMethods2, (String)",")) {
                source.addTransactionalMethod(method, (TransactionAttribute)attr2);
            }
        } else {
            source.addTransactionalMethod("*", (TransactionAttribute)attr2);
        }
        List<DynamicTransactionProperties.TransactionalMethodsRule> rules = this.properties.getRules();
        if (!CollectionUtils.isEmpty(rules)) {
            for (DynamicTransactionProperties.TransactionalMethodsRule rule : rules) {
                String[] methods2;
                RuleBasedTransactionAttribute attr3 = new RuleBasedTransactionAttribute();
                attr3.setPropagationBehavior(rule.getPropagation().getNumber());
                attr3.setIsolationLevel(rule.getIsolation().getNumber());
                if (rule.getTimeout() > 0) {
                    attr3.setTimeout(rule.getTimeout());
                }
                if (rule.isReadOnly()) {
                    attr3.setReadOnly(rule.isReadOnly());
                }
                String noRollbackExceptions = rule.getNoRollbackExceptions();
                String rollbackExceptions = rule.getRollbackExceptions();
                if (!Strings.isNotBlank((CharSequence)noRollbackExceptions)) {
                    noRollbackExceptions = this.properties.getNoRollbackExceptions();
                }
                if (!Strings.isNotBlank((CharSequence)rollbackExceptions)) {
                    rollbackExceptions = this.properties.getRollbackExceptions();
                }
                this.addRollbackRules(attr3, rollbackExceptions, noRollbackExceptions);
                String ruleMethods = rule.getMethods();
                if (!Strings.isNotBlank((CharSequence)ruleMethods)) continue;
                for (String method : methods2 = Strings.tokenizeToArray((String)ruleMethods, (String)",")) {
                    source.addTransactionalMethod(method, (TransactionAttribute)attr3);
                }
            }
        }
        return source;
    }

    private void addRollbackRules(RuleBasedTransactionAttribute attr, String rollbackExceptions, String noRollbackExceptions) {
        String[] exceptions;
        if (Strings.isNotBlank((CharSequence)noRollbackExceptions)) {
            for (String exception : exceptions = Strings.tokenizeToArray((String)noRollbackExceptions, (String)",")) {
                attr.getRollbackRules().add(new NoRollbackRuleAttribute(exception));
            }
        }
        if (Strings.isNotBlank((CharSequence)rollbackExceptions)) {
            for (String exception : exceptions = Strings.tokenizeToArray((String)rollbackExceptions, (String)",")) {
                attr.getRollbackRules().add(new RollbackRuleAttribute(exception));
            }
        }
    }

    protected AnnotationTransactionAttributeSource buildAnnotationTxAttrSource() {
        return new AnnotationTransactionAttributeSource(false);
    }

    protected AnnotationTransactionAttributeSource buildMethodAnnotationTxAttrSource() {
        return new AnnotationTransactionAttributeSource(false){

            protected TransactionAttribute findTransactionAttribute(Class<?> clazz) {
                return null;
            }
        };
    }

    protected AnnotationTransactionAttributeSource buildClassAnnotationTxAttrSource() {
        return new AnnotationTransactionAttributeSource(false){

            protected TransactionAttribute findTransactionAttribute(Method method) {
                return null;
            }
        };
    }

    static class ClassAnnotationFilter
    implements ClassFilter {
        private final Class<? extends Annotation> annotationType;
        private final boolean matchesMethod;

        public boolean matches(Class<?> targetClass) {
            if (AnnotatedElementUtils.hasAnnotation(targetClass, this.annotationType)) {
                return true;
            }
            if (this.matchesMethod) {
                LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
                if (!Proxy.isProxyClass(targetClass)) {
                    classes.add(ClassUtils.getUserClass(targetClass));
                }
                classes.addAll(ClassUtils.getAllInterfacesForClassAsSet(targetClass));
                for (Class clazz : classes) {
                    Method[] methods;
                    for (Method method : methods = ReflectionUtils.getAllDeclaredMethods((Class)clazz)) {
                        if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, this.annotationType)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public ClassAnnotationFilter(Class<? extends Annotation> annotationType, boolean matchesMethod) {
            this.annotationType = annotationType;
            this.matchesMethod = matchesMethod;
        }
    }
}

