/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.condition;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Conditional(value={OnCondition.class})
public @interface ConditionalOnEnableCryptoProperties {

    public static class OnCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enabled = (Boolean)context.getEnvironment().getProperty("platform.crypto.enabled", Boolean.class);
            if (Boolean.TRUE.equals(enabled)) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnEnableCryptoProperties.class, (Object[])new Object[0]).because("match"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnEnableCryptoProperties.class, (Object[])new Object[0]).because("not match"));
        }
    }
}

