/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.condition;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Conditional(value={OnCondition.class})
public @interface ConditionalOnAspectJAutoProxy {

    public static class OnCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            boolean hasBean = beanFactory.containsBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator");
            if (hasBean) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAspectJAutoProxy.class, (Object[])new Object[0]).because("match"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAspectJAutoProxy.class, (Object[])new Object[0]).because("not match"));
        }
    }
}

