/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.condition;

import io.polaris.core.string.Strings;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Conditional(value={OnCondition.class})
public @interface ConditionalOnAllProperty {
    public String prefix() default "";

    public String[] name() default {};

    public String[] values() default {};

    public boolean matchIfMissing() default false;

    public static class OnCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConditionalOnAllProperty.class.getName()));
            if (attributes == null) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAllProperty.class, (Object[])new Object[0]).because("no metadata"));
            }
            Environment env = context.getEnvironment();
            Spec spec = new Spec(attributes);
            return spec.matches(env);
        }

        static class Spec {
            private final boolean matchIfMissing;
            private final String prefix;
            private final String[] name;
            private final Set<Object> values;

            public Spec(AnnotationAttributes attributes) {
                this.matchIfMissing = attributes.getBoolean("matchIfMissing");
                this.prefix = attributes.getString("prefix");
                this.name = attributes.getStringArray("name");
                this.values = new HashSet<Object>();
                Collections.addAll(this.values, attributes.getStringArray("values"));
            }

            public ConditionOutcome matches(Environment env) {
                if (this.name.length == 0) {
                    if (!Strings.isNotBlank((CharSequence)this.prefix)) {
                        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAllProperty.class, (Object[])new Object[0]).because("no specified names"));
                    }
                    String key = this.prefix;
                    String val = env.getProperty(key);
                    if (val == null && !this.matchIfMissing) {
                        return this.noMatched();
                    }
                    if (!this.values.contains(val)) {
                        return this.noMatched();
                    }
                    return this.matched();
                }
                for (String s : this.name) {
                    String key = this.prefix + "." + s;
                    String val = env.getProperty(key);
                    if (val == null && !this.matchIfMissing) {
                        return this.noMatched();
                    }
                    if (this.values.contains(val)) continue;
                    return this.noMatched();
                }
                return this.matched();
            }

            private ConditionOutcome matched() {
                ConditionMessage message = ConditionMessage.forCondition(ConditionalOnAllProperty.class, (Object[])new Object[0]).because("match " + this.toString() + "");
                return ConditionOutcome.match((ConditionMessage)message);
            }

            private ConditionOutcome noMatched() {
                ConditionMessage message = ConditionMessage.forCondition(ConditionalOnAllProperty.class, (Object[])new Object[0]).because("not match " + this.toString() + "");
                return ConditionOutcome.noMatch((ConditionMessage)message);
            }

            public String toString() {
                return "AnyPropertyCondition{matchIfMissing=" + this.matchIfMissing + ", prefix='" + this.prefix + '\'' + ", name=" + Arrays.toString(this.name) + ", anyValue=" + this.values + '}';
            }
        }
    }
}

