/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.autoconfigure;

import io.polaris.framework.core.context.AppCtx;
import io.polaris.framework.core.context.autoconfigure.AutoConfigurationHelper;
import io.polaris.framework.core.version.CodeVersions;
import io.polaris.framework.toolkit.autoconfigure.DefaultBanner;
import io.polaris.framework.toolkit.crypto.CryptoPropertiesBeanHelper;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class ToolkitApplicationListener
implements ApplicationListener<SpringApplicationEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ToolkitApplicationListener.class);

    public void onApplicationEvent(SpringApplicationEvent event) {
        boolean inBootstrap;
        SpringApplication springApplication = event.getSpringApplication();
        if (AutoConfigurationHelper.addMainApplicationIfAbsent((SpringApplication)springApplication) == null) {
            Object[] args = event.getArgs();
            System.out.printf("springApplication: %s, args: %s%n", springApplication, Arrays.toString(args));
        }
        if (inBootstrap = AutoConfigurationHelper.isBootstrapApplication((SpringApplication)springApplication)) {
            System.out.printf("\u5ffd\u7565BootstrapApplicationListener\u89e6\u53d1\u7684Bootstrap\u4e0a\u4e0b\u6587\u4e8b\u4ef6: %s%n", event.getClass().getName());
            return;
        }
        if (event instanceof ApplicationStartingEvent) {
            System.out.println("****** application starting ...");
            return;
        }
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            log.info("****** on environment prepared ");
            this.onEnvironmentPrepared((ApplicationEnvironmentPreparedEvent)event);
            return;
        }
        if (event instanceof ApplicationPreparedEvent) {
            log.info("****** on application prepared ");
            this.onApplicationPrepare((ApplicationPreparedEvent)event);
            return;
        }
        if (event instanceof ApplicationReadyEvent) {
            log.info("****** on application ready ");
            this.onApplicationReady((ApplicationReadyEvent)event);
            return;
        }
        if (event instanceof ApplicationFailedEvent) {
            log.info("****** on application failed ");
            this.onApplicationFailed((ApplicationFailedEvent)event);
            return;
        }
    }

    private void onEnvironmentPrepared(ApplicationEnvironmentPreparedEvent event) {
        System.setProperty("application.formatted-version", "v" + CodeVersions.VERSION);
        ConfigurableEnvironment environment = event.getEnvironment();
        SpringApplication springApplication = event.getSpringApplication();
        AppCtx.bindEnvironment((Environment)environment);
        DefaultBanner.attachToIfNecessary(springApplication);
        CryptoPropertiesBeanHelper.determineCryptoCapability(environment, springApplication);
    }

    private void onApplicationPrepare(ApplicationPreparedEvent event) {
        AppCtx.bindContext((ApplicationContext)event.getApplicationContext());
    }

    private void onApplicationReady(ApplicationReadyEvent event) {
        List packageList = AutoConfigurationPackages.get((BeanFactory)event.getApplicationContext().getBeanFactory());
        String basePackage = ToolkitApplicationListener.class.getPackage().getName();
        for (String packageName : packageList) {
            if (!basePackage.startsWith(packageName)) continue;
            throw new IllegalArgumentException("\u7981\u6b62\u4f7f\u7528\u5e94\u7528\u626b\u63cf\u5305\u8def\u5f84\uff1a" + packageName);
        }
    }

    private void onApplicationFailed(ApplicationFailedEvent event) {
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

