/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.autoconfigure;

import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import io.polaris.framework.toolkit.elasticjob.context.JobCtx;
import io.polaris.framework.toolkit.elasticjob.context.JobCtxHolder;
import io.polaris.framework.toolkit.elasticjob.properties.ElasticJobProperties;
import io.polaris.framework.toolkit.elasticjob.repository.JobRepository;
import io.polaris.framework.toolkit.elasticjob.repository.RdbJobRepository;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={LiteJobConfiguration.class})
@EnableConfigurationProperties(value={ElasticJobProperties.class})
@ConditionalOnProperty(prefix="platform.elasticjob", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class ElasticJobAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticJobAutoConfiguration.class);
    private final ElasticJobProperties properties;

    public ElasticJobAutoConfiguration(ElasticJobProperties properties) {
        this.properties = properties;
    }

    @Bean
    public JobCtx jobCtx(ConfigurableApplicationContext context, DataSource dataSource, ObjectProvider<JobRepository> jobRepositoryProvider, ObjectProvider<ZookeeperRegistryCenter> regCenterProvider) {
        JobRepository jobRepository = (JobRepository)jobRepositoryProvider.getIfAvailable(() -> new RdbJobRepository(dataSource));
        JobCtx jobCtx = new JobCtx(context, dataSource, jobRepository, this.properties);
        ZookeeperRegistryCenter regCenter = (ZookeeperRegistryCenter)regCenterProvider.getIfAvailable();
        if (regCenter != null) {
            jobCtx.bindZookeeperRegistryCenter(regCenter);
        }
        JobCtxHolder.set(jobCtx);
        return jobCtx;
    }

    @Bean
    public ElasticJobSchedulerListener elasticJobSchedulerListener(JobCtx jobCtx) {
        return new ElasticJobSchedulerListener(jobCtx);
    }

    public static class ElasticJobSchedulerListener
    implements ApplicationListener<ApplicationReadyEvent> {
        private static final Logger log = LoggerFactory.getLogger(ElasticJobSchedulerListener.class);
        private final JobCtx jobCtx;
        private volatile boolean started = false;

        public ElasticJobSchedulerListener(JobCtx jobCtx) {
            this.jobCtx = jobCtx;
        }

        public void onApplicationEvent(ApplicationReadyEvent event) {
            if (this.started) {
                log.warn("\u4efb\u52a1\u8c03\u5ea6\u4e2d\u5fc3\u5df2\u7ecf\u542f\u52a8\uff0c\u65e0\u9700\u518d\u6b21\u6267\u884c");
                return;
            }
            this.jobCtx.startup();
            this.started = true;
        }
    }
}

