/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.autoconfigure;

import io.polaris.core.string.Strings;
import io.polaris.framework.toolkit.autoconfigure.DynamicDataSourceAutoConfiguration;
import io.polaris.framework.toolkit.jdbc.flyway.DynamicFlyway;
import io.polaris.framework.toolkit.jdbc.flyway.DynamicFlywayMigrationStrategy;
import io.polaris.framework.toolkit.jdbc.flyway.DynamicFlywayProperties;
import io.polaris.framework.toolkit.jdbc.flyway.TargetFlywayProperties;
import java.sql.DatabaseMetaData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="platform.flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DynamicDataSourceAutoConfiguration.class, DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@EnableConfigurationProperties(value={DynamicFlywayProperties.class, FlywayProperties.class})
public class DynamicFlywayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicFlywayAutoConfiguration.class);

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean
    public FlywayMigrationStrategy flywayInitializer() {
        return new DynamicFlywayMigrationStrategy();
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean
    public FlywayMigrationInitializer flywayMigrationInitializer(Flyway flyway, FlywayMigrationStrategy migrationStrategy) {
        return new FlywayMigrationInitializer(flyway, migrationStrategy);
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean
    public Flyway flyway(DynamicFlywayProperties dynamicFlywayProperties, FlywayProperties flywayProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<JavaMigration> javaMigrations, ObjectProvider<Callback> callbacks) {
        Flyway flyway;
        DynamicFlyway dynamicFlyway = new DynamicFlyway();
        DataSource ds = (DataSource)flywayDataSource.getIfAvailable(() -> dataSource.getIfAvailable());
        if (ds instanceof AbstractRoutingDataSource) {
            Map resolvedDataSources = ((AbstractRoutingDataSource)ds).getResolvedDataSources();
            if (dynamicFlywayProperties.isEnabled()) {
                for (Map.Entry<String, TargetFlywayProperties> entry : dynamicFlywayProperties.getDynamic().entrySet()) {
                    DataSource resolvedDataSource;
                    String key = entry.getKey();
                    FlywayProperties properties = entry.getValue().toFlywayProperties();
                    Flyway flyway2 = this.buildFlyway(resourceLoader, properties, key, resolvedDataSource = (DataSource)resolvedDataSources.get(key), fluentConfigurationCustomizers, javaMigrations, callbacks);
                    if (flyway2 == null) continue;
                    dynamicFlyway.add(flyway2);
                }
            } else if (flywayProperties.isEnabled()) {
                Flyway flyway3;
                DataSource defaultDataSource = ((AbstractRoutingDataSource)ds).getResolvedDefaultDataSource();
                String defaultName = "default";
                if (defaultDataSource != null) {
                    for (Map.Entry entry : resolvedDataSources.entrySet()) {
                        if (defaultDataSource != entry.getValue()) continue;
                        defaultName = Objects.toString(entry.getKey(), "default");
                        break;
                    }
                }
                if ((flyway3 = this.buildFlyway(resourceLoader, flywayProperties, defaultName, defaultDataSource, fluentConfigurationCustomizers, javaMigrations, callbacks)) != null) {
                    dynamicFlyway.add(flyway3);
                }
            }
        } else if (flywayProperties.isEnabled() && (flyway = this.buildFlyway(resourceLoader, flywayProperties, "default", ds, fluentConfigurationCustomizers, javaMigrations, callbacks)) != null) {
            dynamicFlyway.add(flyway);
        }
        return dynamicFlyway;
    }

    Flyway buildFlyway(ResourceLoader resourceLoader, FlywayProperties properties, String dataSourceName, DataSource dataSource, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<JavaMigration> javaMigrations, ObjectProvider<Callback> callbacks) {
        FluentConfiguration configuration = new FluentConfiguration(resourceLoader.getClassLoader());
        DataSource dataSourceToMigrate = this.configureDataSource(configuration, properties, dataSource);
        if (dataSourceToMigrate == null) {
            return null;
        }
        boolean checked = this.checkLocationExists(dataSourceName, dataSourceToMigrate, properties, resourceLoader);
        if (!checked) {
            return null;
        }
        this.configureProperties(dataSourceName, configuration, properties);
        List<Callback> orderedCallbacks = callbacks.orderedStream().collect(Collectors.toList());
        this.configureCallbacks(configuration, orderedCallbacks);
        fluentConfigurationCustomizers.orderedStream().forEach(customizer -> customizer.customize(configuration));
        this.configureFlywayCallbacks(configuration, orderedCallbacks);
        List<JavaMigration> migrations = javaMigrations.stream().collect(Collectors.toList());
        this.configureJavaMigrations(configuration, migrations);
        return configuration.load();
    }

    private DataSource configureDataSource(FluentConfiguration configuration, FlywayProperties properties, DataSource dataSource) {
        String url = properties.getUrl();
        String user = properties.getUser();
        String password = properties.getPassword();
        if (Strings.isNotBlank((CharSequence)url) && Strings.isNotBlank((CharSequence)user) && Strings.isNotBlank((CharSequence)password)) {
            configuration.dataSource(url, user, password);
        } else {
            configuration.dataSource(dataSource);
        }
        return configuration.getDataSource();
    }

    private boolean checkLocationExists(String dataSourceName, DataSource dataSource, FlywayProperties properties, ResourceLoader resourceLoader) {
        List<String> locations = new LocationResolver(dataSourceName, dataSource).resolveLocations(properties.getLocations());
        if (!this.hasAtLeastOneLocation(resourceLoader, locations)) {
            if (properties.isCheckLocation()) {
                throw new IllegalStateException("flyway script locations not configured");
            }
            log.error("flyway script locations not configured");
            return false;
        }
        return true;
    }

    private boolean hasAtLeastOneLocation(ResourceLoader resourceLoader, Collection<String> locations) {
        for (String location : locations) {
            if (!resourceLoader.getResource(this.normalizePrefix(location)).exists()) continue;
            return true;
        }
        return false;
    }

    private String normalizePrefix(String location) {
        return location.replace("filesystem:", "file:");
    }

    private void configureProperties(String dataSourceName, FluentConfiguration configuration, FlywayProperties properties) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        String[] locations = new LocationResolver(dataSourceName, configuration.getDataSource()).resolveLocations(properties.getLocations()).toArray(new String[0]);
        map.from((Object)locations).to(arg_0 -> ((FluentConfiguration)configuration).locations(arg_0));
        map.from((Object)properties.getEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).encoding(arg_0));
        map.from((Object)properties.getConnectRetries()).to(arg_0 -> ((FluentConfiguration)configuration).connectRetries(arg_0));
        map.from((Object)properties.getDefaultSchema()).to(schema -> configuration.defaultSchema(schema));
        map.from((Object)properties.getSchemas()).as(Strings::toArray).to(arg_0 -> ((FluentConfiguration)configuration).schemas(arg_0));
        map.from((Object)properties.getTable()).to(arg_0 -> ((FluentConfiguration)configuration).table(arg_0));
        map.from((Object)properties.getTablespace()).whenNonNull().to(tablespace -> configuration.tablespace(tablespace));
        map.from((Object)properties.getBaselineDescription()).to(arg_0 -> ((FluentConfiguration)configuration).baselineDescription(arg_0));
        map.from((Object)properties.getBaselineVersion()).to(arg_0 -> ((FluentConfiguration)configuration).baselineVersion(arg_0));
        map.from((Object)properties.getInstalledBy()).to(arg_0 -> ((FluentConfiguration)configuration).installedBy(arg_0));
        map.from((Object)properties.getPlaceholders()).to(arg_0 -> ((FluentConfiguration)configuration).placeholders(arg_0));
        map.from((Object)properties.getPlaceholderPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderPrefix(arg_0));
        map.from((Object)properties.getPlaceholderSuffix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderSuffix(arg_0));
        map.from((Object)properties.isPlaceholderReplacement()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderReplacement(arg_0));
        map.from((Object)properties.getSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationPrefix(arg_0));
        map.from((Object)properties.getSqlMigrationSuffixes()).as(Strings::toArray).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSuffixes(arg_0));
        map.from((Object)properties.getSqlMigrationSeparator()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSeparator(arg_0));
        map.from((Object)properties.getRepeatableSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).repeatableSqlMigrationPrefix(arg_0));
        map.from((Object)properties.getTarget()).to(arg_0 -> ((FluentConfiguration)configuration).target(arg_0));
        map.from((Object)properties.isBaselineOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).baselineOnMigrate(arg_0));
        map.from((Object)properties.isCleanDisabled()).to(arg_0 -> ((FluentConfiguration)configuration).cleanDisabled(arg_0));
        map.from((Object)properties.isCleanOnValidationError()).to(arg_0 -> ((FluentConfiguration)configuration).cleanOnValidationError(arg_0));
        map.from((Object)properties.isGroup()).to(arg_0 -> ((FluentConfiguration)configuration).group(arg_0));
        map.from((Object)properties.isIgnoreMissingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreMissingMigrations(arg_0));
        map.from((Object)properties.isIgnoreIgnoredMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreIgnoredMigrations(arg_0));
        map.from((Object)properties.isIgnorePendingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignorePendingMigrations(arg_0));
        map.from((Object)properties.isIgnoreFutureMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreFutureMigrations(arg_0));
        map.from((Object)properties.isMixed()).to(arg_0 -> ((FluentConfiguration)configuration).mixed(arg_0));
        map.from((Object)properties.isOutOfOrder()).to(arg_0 -> ((FluentConfiguration)configuration).outOfOrder(arg_0));
        map.from((Object)properties.isSkipDefaultCallbacks()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultCallbacks(arg_0));
        map.from((Object)properties.isSkipDefaultResolvers()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultResolvers(arg_0));
        this.configureValidateMigrationNaming(configuration, properties.isValidateMigrationNaming());
        map.from((Object)properties.isValidateOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).validateOnMigrate(arg_0));
        map.from((Object)properties.getInitSqls()).whenNot(CollectionUtils::isEmpty).as(initSqls -> Strings.join((CharSequence)"\n", (Iterable)initSqls)).to(arg_0 -> ((FluentConfiguration)configuration).initSql(arg_0));
        map.from((Object)properties.getBatch()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).batch(arg_0));
        map.from((Object)properties.getDryRunOutput()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).dryRunOutput(arg_0));
        map.from((Object)properties.getErrorOverrides()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).errorOverrides(arg_0));
        map.from((Object)properties.getLicenseKey()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).licenseKey(arg_0));
        map.from((Object)properties.getOracleSqlplus()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).oracleSqlplus(arg_0));
        map.from((Object)properties.getOracleSqlplusWarn()).whenNonNull().to(oracleSqlplusWarn -> configuration.oracleSqlplusWarn(oracleSqlplusWarn.booleanValue()));
        map.from((Object)properties.getStream()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).stream(arg_0));
        map.from((Object)properties.getUndoSqlMigrationPrefix()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).undoSqlMigrationPrefix(arg_0));
    }

    private void configureValidateMigrationNaming(FluentConfiguration configuration, boolean validateMigrationNaming) {
        try {
            configuration.validateMigrationNaming(validateMigrationNaming);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void configureCallbacks(FluentConfiguration configuration, List<Callback> callbacks) {
        if (!callbacks.isEmpty()) {
            configuration.callbacks(callbacks.toArray(new Callback[0]));
        }
    }

    private void configureFlywayCallbacks(FluentConfiguration flyway, List<Callback> callbacks) {
        if (!callbacks.isEmpty()) {
            flyway.callbacks(callbacks.toArray(new Callback[0]));
        }
    }

    private void configureJavaMigrations(FluentConfiguration flyway, List<JavaMigration> migrations) {
        if (!migrations.isEmpty()) {
            try {
                flyway.javaMigrations(migrations.toArray(new JavaMigration[0]));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    static class FlywayCondition
    extends AllNestedConditions {
        public FlywayCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="platform.flyway", name={"enabled"}, matchIfMissing=true)
        private static final class FlywayEnabledCondition {
            private FlywayEnabledCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    private static class LocationResolver {
        private final DataSource dataSource;
        private final String dataSourceName;

        LocationResolver(String dataSourceName, DataSource dataSource) {
            this.dataSourceName = dataSourceName;
            this.dataSource = dataSource;
        }

        List<String> resolveLocations(List<String> locations) {
            if (this.usesVendorLocation(locations = this.replaceVendorLocations(locations))) {
                DatabaseDriver databaseDriver = this.getDatabaseDriver();
                return this.replaceVendorLocations(locations, databaseDriver);
            }
            return locations;
        }

        private List<String> replaceVendorLocations(List<String> locations) {
            return locations.stream().map(location -> location.replace("{target}", this.dataSourceName)).collect(Collectors.toList());
        }

        private List<String> replaceVendorLocations(List<String> locations, DatabaseDriver databaseDriver) {
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                return locations;
            }
            String vendor = databaseDriver.getId();
            return locations.stream().map(location -> location.replace("{vendor}", vendor)).collect(Collectors.toList());
        }

        private DatabaseDriver getDatabaseDriver() {
            try {
                String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, DatabaseMetaData::getURL);
                return DatabaseDriver.fromJdbcUrl((String)url);
            }
            catch (MetaDataAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean usesVendorLocation(Collection<String> locations) {
            for (String location : locations) {
                if (!location.contains("{vendor}")) continue;
                return true;
            }
            return false;
        }
    }
}

