/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.autoconfigure;

import io.polaris.core.io.IO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.SpringApplication;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class DefaultBanner
extends ResourceBanner
implements Banner {
    private static final Logger log = LoggerFactory.getLogger(DefaultBanner.class);
    private static final String DEFAULT = "${AnsiColor.BRIGHT_MAGENTA}\n:: Project (${application.formatted-version: unknown-version}) :\uff3c(^O^)\uff0f:  Spring-Boot ${spring-boot.formatted-version}${AnsiColor.DEFAULT}\n";

    public DefaultBanner() {
        super((Resource)DefaultBanner.buildResource());
    }

    private static InputStreamResource buildResource() {
        try {
            InputStream in = IO.getInputStream((String)"banner.txt", DefaultBanner.class);
            return new InputStreamResource(in);
        }
        catch (IOException e) {
            log.warn("Banner file cannot read");
            return new InputStreamResource((InputStream)new ByteArrayInputStream(DEFAULT.getBytes(StandardCharsets.UTF_8)));
        }
    }

    public static void attachToIfNecessary(SpringApplication springApplication) {
        try {
            Field field = springApplication.getClass().getDeclaredField("banner");
            field.setAccessible(true);
            Object o = field.get(springApplication);
            if (o == null) {
                springApplication.setBanner((Banner)new DefaultBanner());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

