/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.autoconfigure;

import io.polaris.framework.toolkit.crypto.CryptoConfigurationProperties;
import io.polaris.framework.toolkit.crypto.CryptoPropertiesServletContextInitializer;
import io.polaris.framework.toolkit.crypto.CryptoPropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CryptoConfigurationProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class CryptoPropertyAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CryptoPropertyAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"platform.crypto.enabled"}, havingValue="true", matchIfMissing=true)
    CryptoPropertyResolver cryptoPropertyResolver(CryptoConfigurationProperties properties) {
        return new CryptoPropertyResolver(properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.web.servlet.ServletContextInitializer", "javax.servlet.ServletContext"})
    @ConditionalOnBean(value={CryptoPropertyResolver.class})
    ServletContextInitializer cryptoPropertiesServletContextInitializer(ConfigurableApplicationContext applicationContext) {
        return new CryptoPropertiesServletContextInitializer(applicationContext);
    }
}

