/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.annotation;

import io.polaris.core.string.Strings;
import io.polaris.framework.core.context.AppCtx;
import io.polaris.framework.core.context.base.Binders;
import io.polaris.framework.toolkit.annotation.AbstractImportSelector;
import io.polaris.framework.toolkit.configuration.DynamicAspectTransactionConfiguration;
import io.polaris.framework.toolkit.configuration.DynamicProxyTransactionConfiguration;
import io.polaris.framework.toolkit.transaction.DynamicTransactionProperties;
import io.polaris.framework.toolkit.transaction.TransactionAspectHelper;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DynamicTransactionConfigurationRegistrar
extends AbstractImportSelector
implements ImportSelector {
    @Override
    public String[] doSelectImports(AnnotationMetadata importingClassMetadata) {
        DynamicTransactionProperties properties;
        boolean enableAspectJAutoProxy = false;
        BeanDefinitionRegistry registry = AppCtx.getBeanDefinitionRegistry();
        if (registry != null) {
            enableAspectJAutoProxy = TransactionAspectHelper.registerAspectJIfNecessary(importingClassMetadata, registry);
        }
        if (!enableAspectJAutoProxy) {
            AnnotationAttributes aspectj = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableAspectJAutoProxy.class.getName(), false));
            boolean bl = enableAspectJAutoProxy = aspectj != null;
        }
        if (AppCtx.getEnvironment() != null && (properties = (DynamicTransactionProperties)Binders.bind((Environment)AppCtx.getEnvironment(), DynamicTransactionProperties.class, (String)"platform.dynamic.transaction")) != null && enableAspectJAutoProxy && properties.isEnableAspectj()) {
            ArrayList<String> list = new ArrayList<String>();
            if (properties.isEnableTransactionalAspect()) {
                list.add(DynamicAspectTransactionConfiguration.TransactionalAspectConfig.class.getName());
            }
            if (properties.isEnableServiceAspect()) {
                list.add(DynamicAspectTransactionConfiguration.SpringServiceAspectConfig.class.getName());
            }
            if (properties.isEnableRepositoryAspect()) {
                list.add(DynamicAspectTransactionConfiguration.SpringRepositoryAspectConfig.class.getName());
            }
            if (Strings.isNotBlank((CharSequence)properties.getClassPattern())) {
                list.add(DynamicAspectTransactionConfiguration.ProxyTransactionConfig.class.getName());
            }
            return list.toArray(new String[0]);
        }
        return new String[]{DynamicProxyTransactionConfiguration.class.getName()};
    }
}

