/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.annotation;

import io.polaris.core.string.Strings;
import io.polaris.framework.core.context.AppCtx;
import io.polaris.framework.core.context.base.Binders;
import io.polaris.framework.toolkit.annotation.AbstractImportBeanDefinitionRegistrar;
import io.polaris.framework.toolkit.annotation.EnableDynamicTransaction;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceAspect;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceBuilder;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceFactory;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceMethodInterceptor;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceProperties;
import io.polaris.framework.toolkit.jdbc.TargetDataSource;
import io.polaris.framework.toolkit.jdbc.TargetDataSourceFactory;
import io.polaris.framework.toolkit.jdbc.init.DataSourceInitializerInvoker;
import io.polaris.framework.toolkit.jdbc.init.DynamicDataSourceInitializerPostProcessor;
import io.polaris.framework.toolkit.jdbc.properties.TargetDataSourceProperties;
import io.polaris.framework.toolkit.support.AnnotationStaticMethodMatcherPointcut;
import io.polaris.framework.toolkit.support.TypePatternClassPointcut;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

class DynamicDataSourceConfigurationRegistrar
extends AbstractImportBeanDefinitionRegistrar
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    DynamicDataSourceConfigurationRegistrar() {
    }

    @Override
    public void doRegisterBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(DynamicDataSourceInitializerPostProcessor.class.getName())) {
            return;
        }
        for (String beanDefinitionName : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanDefinitionName);
            if (!DynamicDataSourceFactory.class.getName().equals(beanDefinition.getBeanClassName()) && !TargetDataSourceFactory.class.getName().equals(beanDefinition.getBeanClassName())) continue;
            return;
        }
        Environment environment = AppCtx.getEnvironment();
        DynamicDataSourceProperties properties = (DynamicDataSourceProperties)Binders.bind((Environment)environment, DynamicDataSourceProperties.class, (String)"platform.dynamic.datasource");
        if (properties == null) {
            return;
        }
        properties.setBeanClassLoader(this.classLoader);
        try {
            properties.afterPropertiesSet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!properties.isMultiple()) {
            this.registerSingle(registry, properties);
        } else {
            this.registerMultiple(registry, properties);
            boolean enableAspectJAutoProxy = this.isEnableAspectJAutoProxy(importingClassMetadata, registry);
            this.registerAnnotationAspect(enableAspectJAutoProxy, registry, properties);
        }
        registry.registerBeanDefinition(DynamicDataSourceInitializerPostProcessor.class.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DynamicDataSourceInitializerPostProcessor.class).setRole(1).getBeanDefinition());
    }

    private void registerSingle(BeanDefinitionRegistry registry, DynamicDataSourceProperties properties) {
        String primaryName;
        TargetDataSourceProperties primary = properties.getPrimary();
        if (primary == null && Strings.isNotBlank((CharSequence)(primaryName = properties.getPrimaryName()))) {
            primary = properties.getTargetDataSourceProperties(primaryName);
        }
        if (primary == null) {
            throw new BeanInitializationException("\u521b\u5efa\u6570\u636e\u6e90\u5b9e\u4f8b\u5931\u8d25\uff01\u672a\u542f\u7528\u591a\u6570\u636e\u6e90\u914d\u7f6e\u4e14\u672a\u914d\u7f6e\u4e3b\u6570\u636e\u6e90\u4fe1\u606f");
        }
        String beanName = properties.getBeanName();
        if (Strings.isNotBlank((CharSequence)beanName)) {
            beanName = this.uniqueBeanName(registry, "dynamicDataSource");
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(TargetDataSourceFactory.class).addConstructorArgValue((Object)beanName).addConstructorArgValue((Object)primary).setPrimary(properties.isRegisterPrimary()).setRole(1);
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        registry.registerBeanDefinition(DataSourceInitializerInvoker.class.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DataSourceInitializerInvoker.class).addConstructorArgReference(beanName).getBeanDefinition());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerMultiple(BeanDefinitionRegistry registry, DynamicDataSourceProperties properties) {
        Object defaultTargetDataSource = null;
        HashMap<Object, TargetDataSourceProperties> targetProperties = new HashMap<Object, TargetDataSourceProperties>();
        TargetDataSourceProperties primary = properties.getPrimary();
        Map<String, TargetDataSourceProperties> targets = properties.getTargets();
        String beanName = properties.getBeanName();
        if (!Strings.isNotBlank((CharSequence)beanName)) {
            beanName = this.uniqueBeanName(registry, "dynamicDataSource");
        }
        if (Strings.isNotBlank((CharSequence)properties.getPrimaryName())) {
            defaultTargetDataSource = properties.getPrimaryName();
            if (!targets.containsKey(defaultTargetDataSource)) {
                if (primary == null) throw new BeanInitializationException("\u521b\u5efa\u6570\u636e\u6e90\u5b9e\u4f8b\u5931\u8d25\uff01\u4e3b\u6570\u636e\u6e90" + (String)defaultTargetDataSource + "\u672a\u914d\u7f6e");
                targetProperties.put(defaultTargetDataSource, primary);
            }
        } else if (primary != null) {
            Object primaryName = "default";
            boolean bl = true;
            while (targets.containsKey(primaryName)) {
                void var9_10;
                primaryName = "default." + (int)(++var9_10);
            }
            defaultTargetDataSource = primaryName;
            targetProperties.put(defaultTargetDataSource, primary);
        }
        if (properties.isEnableAllTargets()) {
            for (Map.Entry entry : targets.entrySet()) {
                targetProperties.put(entry.getKey(), (TargetDataSourceProperties)entry.getValue());
            }
        } else {
            String names = properties.getTargetNames();
            if (!Strings.isNotBlank((CharSequence)names)) {
                throw new BeanInitializationException("\u65e0\u6cd5\u521b\u5efa\u591a\u6570\u636e\u6e90\u5b9e\u4f8b\uff01\u672a\u6307\u5b9a\u6570\u636e\u6e90\u540d\u79f0\u5217\u8868");
            }
            String[] stringArray = Strings.tokenizeToArray((String)names, (String)",", (boolean)true, (boolean)true);
            for (String name : stringArray) {
                TargetDataSourceProperties dataSourceProperties = targets.get(name);
                if (dataSourceProperties == null) {
                    throw new BeanInitializationException("\u672a\u914d\u7f6e\u76ee\u6807\u6570\u636e\u6e90\uff1a" + name);
                }
                targetProperties.put(name, dataSourceProperties);
            }
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DynamicDataSourceFactory.class).setPrimary(properties.isRegisterPrimary()).setRole(1).addConstructorArgValue((Object)properties).addConstructorArgValue(defaultTargetDataSource).addConstructorArgValue(targetProperties);
        if (properties.isRegisterAllTargets()) {
            ManagedMap managedMap = new ManagedMap();
            managedMap.setKeyTypeName(String.class.getName());
            managedMap.setValueTypeName(DataSource.class.getName());
            for (Map.Entry entry : targetProperties.entrySet()) {
                String key = (String)entry.getKey();
                String dsBeanName = beanName + "." + key;
                TargetDataSourceProperties value = (TargetDataSourceProperties)entry.getValue();
                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(TargetDataSourceFactory.class).addConstructorArgValue((Object)dsBeanName).addConstructorArgValue((Object)value).setRole(1).getBeanDefinition();
                registry.registerBeanDefinition(dsBeanName, (BeanDefinition)beanDefinition);
                managedMap.put((Object)key, (Object)new RuntimeBeanReference(dsBeanName));
                if (!Strings.isNotBlank((CharSequence)value.getClassPattern())) continue;
                this.registerClassPatternAspectBean(registry, key, value.getClassPattern());
            }
            builder.addConstructorArgValue((Object)managedMap);
        } else {
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : targetProperties.entrySet()) {
                TargetDataSourceProperties value = (TargetDataSourceProperties)entry.getValue();
                DataSource dataSource = DynamicDataSourceBuilder.create(value.getClassLoader()).properties(value).build();
                hashMap.put(entry.getKey(), dataSource);
                if (!Strings.isNotBlank((CharSequence)value.getClassPattern())) continue;
                this.registerClassPatternAspectBean(registry, (String)entry.getKey(), value.getClassPattern());
            }
            builder.addConstructorArgValue(hashMap);
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        registry.registerBeanDefinition(DataSourceInitializerInvoker.class.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DataSourceInitializerInvoker.class).addConstructorArgReference(beanName).getBeanDefinition());
    }

    private boolean isEnableAspectJAutoProxy(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes;
        boolean enableAspectJAutoProxy = registry.containsBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator");
        if (!enableAspectJAutoProxy && (annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableDynamicTransaction.class.getName(), false))) != null) {
            enableAspectJAutoProxy = annotationAttributes.getBoolean("enableAspectJAutoProxy");
        }
        if (!enableAspectJAutoProxy) {
            AnnotationAttributes aspectj = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableAspectJAutoProxy.class.getName(), false));
            enableAspectJAutoProxy = aspectj != null;
        }
        return enableAspectJAutoProxy;
    }

    private void registerAnnotationAspect(boolean enableAspectJAutoProxy, BeanDefinitionRegistry registry, DynamicDataSourceProperties properties) {
        if (enableAspectJAutoProxy && properties.isEnableAspectj()) {
            AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(DynamicDataSourceAspect.class);
            beanDefinition.setRole(1);
            registry.registerBeanDefinition("dynamicDataSourceAspect", (BeanDefinition)beanDefinition);
        } else {
            AnnotationStaticMethodMatcherPointcut pointcut = new AnnotationStaticMethodMatcherPointcut(TargetDataSource.class);
            DynamicDataSourceMethodInterceptor advice = new DynamicDataSourceMethodInterceptor();
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(DefaultPointcutAdvisor.class).addConstructorArgValue((Object)pointcut).addConstructorArgValue((Object)advice).setRole(1).getBeanDefinition();
            registry.registerBeanDefinition("dynamicDataSourceAspect", (BeanDefinition)beanDefinition);
        }
    }

    private void registerClassPatternAspectBean(BeanDefinitionRegistry registry, String key, String classPattern) {
        TypePatternClassPointcut pointcut = new TypePatternClassPointcut(classPattern);
        DynamicDataSourceMethodInterceptor advice = new DynamicDataSourceMethodInterceptor(key);
        registry.registerBeanDefinition("dynamicDataSourceAspect." + key, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DefaultPointcutAdvisor.class).addConstructorArgValue((Object)pointcut).addConstructorArgValue((Object)advice).setRole(1).getBeanDefinition());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

