/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework;

import io.polaris.framework.BasePackage;
import io.polaris.framework.BasicComponentAutoConfiguration;
import io.polaris.framework.core.context.AppCtx;
import io.polaris.framework.core.context.env.properties.Rest;
import io.polaris.framework.http.restfull.CommonRestController;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartResolver;

@Configuration
@AutoConfigureAfter(value={BasicComponentAutoConfiguration.class})
@ServletComponentScan(basePackageClasses={BasePackage.class})
@Import(value={})
@ConditionalOnWebApplication
public class CommonRestAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CommonRestAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"platform.rest.enabled"}, havingValue="true", matchIfMissing=true)
    public CommonRestController commonRest(MultipartResolver multipartResolver) {
        return new CommonRestController(multipartResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        StringHttpMessageConverter c = new StringHttpMessageConverter(StandardCharsets.UTF_8);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().set(1, c);
        restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).additionalMessageConverters((Collection)restTemplate.getMessageConverters()).uriTemplateHandler(restTemplate.getUriTemplateHandler()).build();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)this.clientHttpRequestFactory());
        ArrayList interceptors = new ArrayList(restTemplate.getInterceptors());
        restTemplate.setInterceptors(interceptors);
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        return restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpComponentsClientHttpRequestFactory clientHttpRequestFactory() {
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
            httpClientBuilder.setSSLContext(sslContext);
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            Rest.Template template = AppCtx.getPlatformProperties().getRest().getTemplate();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connectionManager.setMaxTotal(template.getMaxTotal());
            connectionManager.setDefaultMaxPerRoute(template.getDefaultMaxPerRoute());
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(template.getSocketTimeout()).setConnectTimeout(template.getConnectTimeout()).setConnectionRequestTimeout(template.getConnectionRequestTimeout()).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }
}

