package org.mybatis.spring.boot.autoconfigure;

import org.apache.ibatis.session.*;

import java.sql.Connection;

/**
 * @author Qt
 * @since 1.8,  Dec 26, 2023
 */
public class SqlSessionFactoryProxy implements SqlSessionFactory {

	private final SqlSessionFactory raw;
	private final ExecutorType executorType;

	public SqlSessionFactoryProxy(SqlSessionFactory raw, ExecutorType executorType) {
		this.raw = raw;
		this.executorType = executorType;
	}

	@Override
	public SqlSession openSession() {
		return raw.openSession(this.executorType);
	}

	@Override
	public SqlSession openSession(boolean autoCommit) {
		return raw.openSession(this.executorType, autoCommit);
	}

	@Override
	public SqlSession openSession(Connection connection) {
		return raw.openSession(this.executorType, connection);
	}

	@Override
	public SqlSession openSession(TransactionIsolationLevel level) {
		return raw.openSession(this.executorType, level);
	}

	@Override
	public SqlSession openSession(ExecutorType execType) {
		return raw.openSession(execType);
	}

	@Override
	public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
		return raw.openSession(execType, autoCommit);
	}

	@Override
	public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
		return raw.openSession(execType, level);
	}

	@Override
	public SqlSession openSession(ExecutorType execType, Connection connection) {
		return raw.openSession(execType, connection);
	}

	@Override
	public Configuration getConfiguration() {
		return raw.getConfiguration();
	}
}
