package io.polaris.framework.mybatis.autoconfigure;

import io.polaris.framework.mybatis.MybatisLogInterceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * @author Qt
 * @since Jun 21, 2024
 */
@org.springframework.context.annotation.Configuration
@ConditionalOnClass({SqlSessionFactory.class, SqlSessionFactoryBean.class})
public class MybatisBeanAutoConfiguration {

	@Bean
	@ConditionalOnMissingBean
	public MybatisLogInterceptor mybatisLogInterceptor() {
		return new MybatisLogInterceptor();
	}
}
