/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.boot.autoconfigure;

import java.sql.Connection;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.TransactionIsolationLevel;

public class SqlSessionFactoryProxy
implements SqlSessionFactory {
    private final SqlSessionFactory raw;
    private final ExecutorType executorType;

    public SqlSessionFactoryProxy(SqlSessionFactory raw, ExecutorType executorType) {
        this.raw = raw;
        this.executorType = executorType;
    }

    public SqlSession openSession() {
        return this.raw.openSession(this.executorType);
    }

    public SqlSession openSession(boolean autoCommit) {
        return this.raw.openSession(this.executorType, autoCommit);
    }

    public SqlSession openSession(Connection connection) {
        return this.raw.openSession(this.executorType, connection);
    }

    public SqlSession openSession(TransactionIsolationLevel level) {
        return this.raw.openSession(this.executorType, level);
    }

    public SqlSession openSession(ExecutorType execType) {
        return this.raw.openSession(execType);
    }

    public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
        return this.raw.openSession(execType, autoCommit);
    }

    public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
        return this.raw.openSession(execType, level);
    }

    public SqlSession openSession(ExecutorType execType, Connection connection) {
        return this.raw.openSession(execType, connection);
    }

    public Configuration getConfiguration() {
        return this.raw.getConfiguration();
    }
}

