/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.boot.autoconfigure;

import io.polaris.framework.core.context.bean.PlatformAnnotationBeanNameGenerator;
import java.beans.FeatureDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.mybatis.spring.boot.autoconfigure.MybatisLanguageDriverAutoConfiguration;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.mybatis.spring.boot.autoconfigure.SqlSessionFactoryProxy;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@EnableConfigurationProperties(value={MybatisProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MybatisLanguageDriverAutoConfiguration.class})
public class MybatisAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MybatisAutoConfiguration.class);

    @Configuration
    @Import(value={AutoConfiguredMapperScannerRegistrar.class})
    @ConditionalOnMissingBean(value={MapperFactoryBean.class, MapperScannerConfigurer.class})
    public static class MapperScannerRegistrarNotFoundConfiguration
    implements InitializingBean {
        public void afterPropertiesSet() {
            logger.debug("Not found configuration for registering mapper bean using @MapperScan, MapperFactoryBean and MapperScannerConfigurer.");
        }
    }

    public static class AutoConfiguredMapperScannerRegistrar
    implements BeanFactoryAware,
    ImportBeanDefinitionRegistrar {
        private BeanFactory beanFactory;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                logger.debug("Could not determine auto-configuration package, automatic mapper scanning disabled.");
                return;
            }
            logger.debug("Searching for mappers annotated with @Mapper");
            List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
            if (logger.isDebugEnabled()) {
                packages.forEach(pkg -> logger.debug("Using auto-configuration base package '{}'", pkg));
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
            builder.addPropertyValue("processPropertyPlaceHolders", (Object)true);
            builder.addPropertyValue("annotationClass", Mapper.class);
            builder.addPropertyValue("nameGenerator", (Object)PlatformAnnotationBeanNameGenerator.INSTANCE);
            builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString((Collection)packages));
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(MapperScannerConfigurer.class);
            Set propertyNames = Stream.of(beanWrapper.getPropertyDescriptors()).map(FeatureDescriptor::getName).collect(Collectors.toSet());
            if (propertyNames.contains("lazyInitialization")) {
                builder.addPropertyValue("lazyInitialization", (Object)"${mybatis.lazy-initialization:false}");
            }
            if (propertyNames.contains("defaultScope")) {
                builder.addPropertyValue("defaultScope", (Object)"${mybatis.mapper-default-scope:}");
            }
            registry.registerBeanDefinition(MapperScannerConfigurer.class.getName(), (BeanDefinition)builder.getBeanDefinition());
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }
    }

    @ConditionalOnMissingBean(value={SqlSessionTemplate.class})
    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    @EnableConfigurationProperties(value={MybatisProperties.class})
    @AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MybatisLanguageDriverAutoConfiguration.class})
    public static class SqlSessionTemplateConfiguration {
        private final MybatisProperties properties;

        public SqlSessionTemplateConfiguration(MybatisProperties properties) {
            this.properties = properties;
        }

        @Bean
        @Primary
        public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
            ExecutorType executorType = this.properties.getExecutorType();
            if (executorType != null) {
                return new SqlSessionTemplate(sqlSessionFactory, executorType);
            }
            return new SqlSessionTemplate(sqlSessionFactory);
        }

        @Bean
        public SqlSessionTemplate batchSqlSessionTemplate(@Qualifier(value="batchSqlSessionFactory") SqlSessionFactory batchSqlSessionFactory) {
            return new SqlSessionTemplate(batchSqlSessionFactory, ExecutorType.BATCH);
        }
    }

    @ConditionalOnMissingBean(value={SqlSessionFactory.class})
    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    @EnableConfigurationProperties(value={MybatisProperties.class})
    @AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MybatisLanguageDriverAutoConfiguration.class})
    public static class SqlSessionFactoryConfiguration
    implements InitializingBean {
        private final MybatisProperties properties;
        private final Interceptor[] interceptors;
        private final TypeHandler[] typeHandlers;
        private final LanguageDriver[] languageDrivers;
        private final ResourceLoader resourceLoader;
        private final DatabaseIdProvider databaseIdProvider;
        private final List<ConfigurationCustomizer> configurationCustomizers;

        public SqlSessionFactoryConfiguration(MybatisProperties properties, ObjectProvider<Interceptor[]> interceptorsProvider, ObjectProvider<TypeHandler[]> typeHandlersProvider, ObjectProvider<LanguageDriver[]> languageDriversProvider, ResourceLoader resourceLoader, ObjectProvider<DatabaseIdProvider> databaseIdProvider, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider) {
            this.properties = properties;
            this.interceptors = (Interceptor[])interceptorsProvider.getIfAvailable();
            this.typeHandlers = (TypeHandler[])typeHandlersProvider.getIfAvailable();
            this.languageDrivers = (LanguageDriver[])languageDriversProvider.getIfAvailable();
            this.resourceLoader = resourceLoader;
            this.databaseIdProvider = (DatabaseIdProvider)databaseIdProvider.getIfAvailable();
            this.configurationCustomizers = (List)configurationCustomizersProvider.getIfAvailable();
        }

        public void afterPropertiesSet() {
            this.checkConfigFileExists();
        }

        private void checkConfigFileExists() {
            if (this.properties.isCheckConfigLocation() && StringUtils.hasText((String)this.properties.getConfigLocation())) {
                Resource resource = this.resourceLoader.getResource(this.properties.getConfigLocation());
                Assert.state((boolean)resource.exists(), (String)("Cannot find config location: " + resource + " (please add config file or check your Mybatis configuration)"));
            }
        }

        @Bean
        @Primary
        public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
            return this.buildSqlSessionFactory(dataSource);
        }

        @Bean
        public SqlSessionFactory batchSqlSessionFactory(DataSource dataSource) throws Exception {
            return new SqlSessionFactoryProxy(this.sqlSessionFactory(dataSource), ExecutorType.BATCH);
        }

        @Nullable
        private SqlSessionFactory buildSqlSessionFactory(DataSource dataSource) throws Exception {
            SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
            factory.setDataSource(dataSource);
            factory.setVfs(SpringBootVFS.class);
            if (StringUtils.hasText((String)this.properties.getConfigLocation())) {
                factory.setConfigLocation(this.resourceLoader.getResource(this.properties.getConfigLocation()));
            }
            this.applyConfiguration(factory);
            if (this.properties.getConfigurationProperties() != null) {
                factory.setConfigurationProperties(this.properties.getConfigurationProperties());
            }
            if (!ObjectUtils.isEmpty((Object[])this.interceptors)) {
                factory.setPlugins(this.interceptors);
            }
            if (this.databaseIdProvider != null) {
                factory.setDatabaseIdProvider(this.databaseIdProvider);
            }
            if (StringUtils.hasLength((String)this.properties.getTypeAliasesPackage())) {
                factory.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
            }
            if (this.properties.getTypeAliasesSuperType() != null) {
                factory.setTypeAliasesSuperType(this.properties.getTypeAliasesSuperType());
            }
            if (StringUtils.hasLength((String)this.properties.getTypeHandlersPackage())) {
                factory.setTypeHandlersPackage(this.properties.getTypeHandlersPackage());
            }
            if (!ObjectUtils.isEmpty((Object[])this.typeHandlers)) {
                factory.setTypeHandlers(this.typeHandlers);
            }
            if (!ObjectUtils.isEmpty((Object[])this.properties.resolveMapperLocations())) {
                factory.setMapperLocations(this.properties.resolveMapperLocations());
            }
            Set factoryPropertyNames = Stream.of(new BeanWrapperImpl(SqlSessionFactoryBean.class).getPropertyDescriptors()).map(FeatureDescriptor::getName).collect(Collectors.toSet());
            Class<Object> defaultLanguageDriver = this.properties.getDefaultScriptingLanguageDriver();
            if (factoryPropertyNames.contains("scriptingLanguageDrivers") && !ObjectUtils.isEmpty((Object[])this.languageDrivers)) {
                factory.setScriptingLanguageDrivers(this.languageDrivers);
                if (defaultLanguageDriver == null && this.languageDrivers.length == 1) {
                    defaultLanguageDriver = this.languageDrivers[0].getClass();
                }
            }
            if (factoryPropertyNames.contains("defaultScriptingLanguageDriver")) {
                factory.setDefaultScriptingLanguageDriver(defaultLanguageDriver);
            }
            return factory.getObject();
        }

        private void applyConfiguration(SqlSessionFactoryBean factory) {
            org.apache.ibatis.session.Configuration configuration = this.properties.getConfiguration();
            if (configuration == null && !StringUtils.hasText((String)this.properties.getConfigLocation())) {
                configuration = new org.apache.ibatis.session.Configuration();
            }
            if (configuration != null && !CollectionUtils.isEmpty(this.configurationCustomizers)) {
                for (ConfigurationCustomizer customizer : this.configurationCustomizers) {
                    customizer.customize(configuration);
                }
            }
            factory.setConfiguration(configuration);
        }
    }
}

