package cn.foofun.forge;

import java.util.List;

public class ValueListSource<T> implements Source<T> {

    List<T> values;

    IntSource intSource;

    public ValueListSource(List<T> values, IntSource intSource) {
        this.values = values;
        this.intSource = intSource;
    }

    public ValueListSource(List<T> values) {
        this.values = values;
        this.intSource = new IntSource(0, values.size() - 1, 1);
    }

    @Override
    public T next() {
        int index = intSource.next();

        return values.get(index);
    }
}
