package cn.foofun.forge;

import cn.foofun.forge.domain.DateRange;

import java.util.Date;

public class SimpleDateRangeSource implements Source<DateRange> {

    Source<Date> dateSource;

    IntSource intSource;

    public SimpleDateRangeSource(Date begin, Date end, int minDays, int maxDays) {

        this.dateSource = new SimpleDateSource(begin, end);
        this.intSource = new IntSource(minDays, maxDays, 1);
    }

    @Override
    public DateRange next() {
        Date value = this.dateSource.next();

        int d = this.intSource.next();

        long time = value.getTime() + d * 1000 * 60 * 60 * 24;

        Date endValue = new Date(time);

        DateRange dateRange = new DateRange(value, endValue);

        return dateRange;
    }
}
