package cn.foofun.forge;

import java.util.Arrays;

public class LinesStringSource implements Source<String> {

    ValueListSource<String> stringSource;

    public LinesStringSource(String input, int nextLines) {

        String regex = "\\r?\\n";

        if (nextLines == 2) {
            regex = "\\r?\\n\\r?\\n";
        }

        String[] lines = input.split(regex, -1);

        this.stringSource = new ValueListSource<String>(Arrays.asList(lines));
    }

    @Override
    public String next() {
        return this.stringSource.next();
    }
}
