package cn.foofun.forge;

import cn.foofun.forge.domain.DateRange;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

public class Forge {

    public static CompositeSourceBuilder buildMap(String key, Source<?> source) {
        CompositeSourceBuilder compositeSourceBuilder = new CompositeSourceBuilder();
        compositeSourceBuilder.add(key, source);

        return compositeSourceBuilder;
    }

    public static Source<Integer> buildInt(int min, int max) {

        return new IntSource(min, max, 1);
    }

    public static Source<String> buildFromClassPath(String fileName) throws IOException {

        InputStream inputStream = Forge.class.getResourceAsStream(fileName);

        Source<String> source = new FileLinesStringSource(inputStream, Charset.defaultCharset(), 1);

        inputStream.close();

        return source;
    }

    public static Source<String> buildFromClassPath2(String fileName) throws IOException {

        InputStream inputStream = Forge.class.getResourceAsStream(fileName);

        Source<String> source = new FileLinesStringSource(inputStream, Charset.defaultCharset(), 2);

        inputStream.close();

        return source;
    }

    public static <T> Source<T> combineSources(Source<T> source1, Source<T> source2, int rate1, int rate2) {
        SimpleTwoSources<T> twoSources = new SimpleTwoSources<T>(source1, source2, rate1, rate2);

        return twoSources;
    }

    public static <T> Source<T> buildInValues(T... values) {

        ValueListSource<T> valueListSource = new ValueListSource<>(Arrays.asList(values));

        return valueListSource;
    }

    public static Source<DateRange> buildInDays(Date begin, Date end, int minDays, int maxDays) {

        SimpleDateRangeSource simpleDateRangeSource = new SimpleDateRangeSource(begin, end, minDays, maxDays);

        return simpleDateRangeSource;
    }

    public static <T> Source<T> buildBySql(Connection connection, String sql, String columnName, Class<T> clazz) throws SQLException {

        ResultSet resultSet = connection.createStatement().executeQuery(sql);

        List<T> values = new ArrayList<T>();

        while (resultSet.next()) {
            T v = resultSet.getObject(columnName, clazz);
            values.add(v);
        }

        ValueListSource<T> valueListSource = new ValueListSource<T>(values);

        return valueListSource;
    }
}
