package com.wink.forge;

import com.wink.forge.domain.IntRange;

import java.util.Random;

public class SimpleIntRangeSource implements Source<IntRange> {

    IntSource startSource;
    int steps;
    int step;

    public SimpleIntRangeSource(int startMin, int startMax, int step, int steps) {
        this.startSource = new IntSource(startMin, startMax, step);
        this.step = step;
        this.steps = steps;
    }

    @Override
    public IntRange next() {
        int b = this.startSource.next();
        int e = b + (new Random().nextInt(steps) + 1) * this.step;

        return new IntRange(b, e);
    }
}
