package com.wink.forge;

import java.util.Date;
import java.util.Random;

public class SimpleDateSource implements Source<Date> {

    Date begin;

    Date end;

    public SimpleDateSource(Date begin, Date end) {
        this.begin = begin;
        this.end = end;
    }

    @Override
    public Date next() {
        long time = begin.getTime();

        int range = (int) (end.getTime() - time);

        int v = new Random().nextInt(range) / 1000 * 1000;

        Date result = new Date(time + v);

        return result;
    }
}
