package com.wink.forge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class FileLinesStringSource implements Source<String> {

    LinesStringSource stringSource;

    public FileLinesStringSource(InputStream fis, Charset charset) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[64 * 1024];
        int len = fis.read(buf);
        while (len > 0) {
            bos.write(buf, 0, len);
            len = fis.read(buf);
        }
        String input = new String(bos.toByteArray(), charset);

        LinesStringSource linesStringSource = new LinesStringSource(input);

        this.stringSource = linesStringSource;
    }

    @Override
    public String next() {
        return this.stringSource.next();
    }
}
