/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.service;

import cn.fntop.config.CustomJacksonConverterFactory;
import cn.fntop.config.OpenApiProperties;
import cn.fntop.service.OpenApi;
import cn.fntop.service.OpenApiContext;
import cn.fntop.service.OpenApiServiceSubject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.reactivex.Single;
import java.net.Proxy;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public abstract class OpenApiServiceAbstract
implements OpenApiServiceSubject {
    private static final String BASE_URL = "http://127.0.0.1:8080/";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    private static ExecutorService executorService;
    private static long defaultExecutorTimeout;
    private static long responseTimeout;
    protected static OpenApi api;

    public static OpenApiServiceSubject getInstance(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject) {
        return OpenApiServiceAbstract.custom(properties, cls, subject, null, null, null);
    }

    public static OpenApiServiceSubject custom(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject, Duration timeout, Interceptor interceptor, Proxy proxy, ObjectMapper mapper) {
        if (OpenApiContext.get(subject) != null) {
            return OpenApiContext.get(subject);
        }
        if (mapper == null) {
            mapper = OpenApiServiceAbstract.defaultObjectMapper();
        }
        OkHttpClient client = OpenApiServiceAbstract.defaultClient(timeout, interceptor, proxy).newBuilder().build();
        Retrofit retrofit1 = OpenApiServiceAbstract.defaultRetrofit(client, mapper, properties.getOpenGateway());
        api = (OpenApi)retrofit1.create(cls);
        OpenApiServiceSubject instance = subject.newInstance();
        OpenApiContext.set(subject, instance);
        return instance;
    }

    public static OpenApiServiceSubject custom(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject, ObjectMapper mapper) {
        return OpenApiServiceAbstract.custom(properties, cls, subject, null, null, null, mapper);
    }

    public static OpenApiServiceSubject custom(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject, Interceptor interceptor) {
        return OpenApiServiceAbstract.custom(properties, cls, subject, null, interceptor, null);
    }

    public static OpenApiServiceSubject custom(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject, Duration timeout) {
        return OpenApiServiceAbstract.custom(properties, cls, subject, timeout, null, null);
    }

    public static OpenApiServiceSubject custom(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject, Duration timeout, Interceptor interceptor, Proxy proxy) {
        return OpenApiServiceAbstract.custom(properties, cls, subject, timeout, interceptor, proxy, null);
    }

    protected static <T> T execute(Single<T> apiCall) {
        if (executorService != null) {
            Object response = executorService.submit(() -> OpenApiServiceAbstract.exe(apiCall)).get(responseTimeout, TimeUnit.MILLISECONDS);
            try {
                executorService.shutdown();
                if (!executorService.awaitTermination(defaultExecutorTimeout, TimeUnit.MILLISECONDS)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
            }
            return (T)response;
        }
        return OpenApiServiceAbstract.exe(apiCall);
    }

    private static <T> T exe(Single<T> apiCall) {
        try {
            Object object = apiCall.blockingGet();
            return (T)object;
        }
        catch (HttpException e) {
            throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    private static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        return mapper;
    }

    private static OkHttpClient defaultClient(Duration timeout) {
        return OpenApiServiceAbstract.defaultClient(timeout, null, null);
    }

    private static OkHttpClient defaultClient(Duration timeout, Interceptor interceptor, Proxy proxy) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS));
        if (timeout == null) {
            builder.readTimeout(DEFAULT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            builder.readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (interceptor != null) {
            builder.addInterceptor(interceptor);
        }
        builder.proxy(proxy);
        return builder.build();
    }

    private static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)CustomJacksonConverterFactory.create(mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    private static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper, String gateway) {
        if (gateway == null) {
            try {
                throw new Exception("\u7f51\u5173\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Retrofit.Builder builder = new Retrofit.Builder().client(client).baseUrl(gateway).addConverterFactory((Converter.Factory)CustomJacksonConverterFactory.create(mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        return builder.build();
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static void setExecutorService(ExecutorService executorService) {
        OpenApiServiceAbstract.executorService = executorService;
    }

    public static long getDefaultExecutorTimeout() {
        return defaultExecutorTimeout;
    }

    public static void setDefaultExecutorTimeout(long defaultExecutorTimeout) {
        OpenApiServiceAbstract.defaultExecutorTimeout = defaultExecutorTimeout;
    }

    public static long getResponseTimeout() {
        return responseTimeout;
    }

    public static void setResponseTimeout(long responseTimeout) {
        OpenApiServiceAbstract.responseTimeout = responseTimeout;
    }

    public static OpenApi getApi() {
        return api;
    }

    public static void setApi(OpenApi api) {
        OpenApiServiceAbstract.api = api;
    }

    static {
        defaultExecutorTimeout = 500L;
        responseTimeout = 30L;
    }
}

