/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.service;

import cn.fntop.config.CustomJacksonConverterFactory;
import cn.fntop.config.OpenApiProperties;
import cn.fntop.service.OpenApi;
import cn.fntop.service.OpenApiContext;
import cn.fntop.service.OpenApiServiceSubject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.theokanning.openai.OpenAiError;
import com.theokanning.openai.OpenAiHttpException;
import io.reactivex.Single;
import java.io.IOException;
import java.net.Proxy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class OpenApiService
implements OpenApiServiceSubject {
    protected static final String BASE_URL = "http://127.0.0.1:8080/";
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    protected static final ObjectMapper mapper = OpenApiService.defaultObjectMapper();
    protected static OpenApi api;
    protected static ExecutorService executorService;
    protected static OpenApiServiceSubject openService;

    public static OpenApiServiceSubject getInstance(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject) {
        return OpenApiService.custom(properties, cls, subject, null, null, null, null);
    }

    public static OpenApiServiceSubject custom(OpenApiProperties properties, Class<? extends OpenApi> cls, Class<? extends OpenApiServiceSubject> subject, Duration timeout, Interceptor interceptor, Proxy proxy, ExecutorService executorService) {
        if (OpenApiContext.get(subject) != null) {
            return OpenApiContext.get(subject);
        }
        ObjectMapper mapper = OpenApiService.defaultObjectMapper();
        OkHttpClient client = OpenApiService.defaultClient(timeout, interceptor, proxy).newBuilder().build();
        Retrofit retrofit1 = OpenApiService.defaultRetrofit(client, mapper, properties.getOpenGateway());
        api = (OpenApi)retrofit1.create(cls);
        OpenApiServiceSubject instance = subject.newInstance();
        OpenApiContext.set(subject, instance);
        OpenApiService.executorService = executorService;
        return instance;
    }

    public Object get(String suffix) {
        return OpenApiService.execute(api.get(suffix));
    }

    public Object get(String suffix, String path) {
        return OpenApiService.execute(api.get(suffix, path));
    }

    public Object getOnQuery(String suffix, String query) {
        return OpenApiService.execute(api.get(suffix, query, true));
    }

    public Object post(String suffix, Object obj) {
        return OpenApiService.execute(api.post(suffix, obj));
    }

    public Object post(String suffix, Object obj, boolean isFile, String folder, MultipartBody.Part ... file) {
        if (isFile) {
            return OpenApiService.execute(api.post(suffix, folder, file));
        }
        return OpenApiService.execute(api.post(suffix, obj));
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                OpenAiError error = (OpenAiError)mapper.readValue(errorBody, OpenAiError.class);
                throw new OpenAiHttpException(error, (Exception)((Object)e), e.code());
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    public void shutdownExecutor() {
        Objects.requireNonNull(executorService, "executorService must be set in order to shut down");
        executorService.shutdown();
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public static OkHttpClient defaultClient(Duration timeout) {
        return OpenApiService.defaultClient(timeout, null, null);
    }

    public static OkHttpClient defaultClient(Duration timeout, Interceptor interceptor, Proxy proxy) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS));
        if (timeout == null) {
            builder.readTimeout(DEFAULT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            builder.readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (interceptor != null) {
            builder.addInterceptor(interceptor);
        }
        builder.proxy(proxy);
        return builder.build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)CustomJacksonConverterFactory.create(mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper, String gateway) {
        if (gateway == null) {
            try {
                throw new Exception("\u7f51\u5173\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Retrofit.Builder builder = new Retrofit.Builder().client(client).baseUrl(gateway).addConverterFactory((Converter.Factory)CustomJacksonConverterFactory.create(mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        return builder.build();
    }

    public static OpenApi getApi() {
        return api;
    }

    public static void setApi(OpenApi api) {
        OpenApiService.api = api;
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static void setExecutorService(ExecutorService executorService) {
        OpenApiService.executorService = executorService;
    }

    public static OpenApiServiceSubject getOpenService() {
        return openService;
    }

    public static void setOpenService(OpenApiServiceSubject openService) {
        OpenApiService.openService = openService;
    }
}

