/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.entity;

import org.springframework.http.HttpStatus;

public class FnResponse<T> {
    protected static final Integer SUCCESS = HttpStatus.OK.value();
    protected static final Integer FAIL = HttpStatus.INTERNAL_SERVER_ERROR.value();
    private static final long serialVersionUID = -5869723792262368348L;
    private int code;
    private String msg;
    private T data;

    public static <T> FnResponse<T> ok() {
        return FnResponse.restResult(null, SUCCESS, null);
    }

    public static <T> FnResponse<T> ok(T data) {
        return FnResponse.restResult(data, SUCCESS, null);
    }

    public static <T> FnResponse<T> ok(T data, String msg) {
        return FnResponse.restResult(data, SUCCESS, msg);
    }

    public static <T> FnResponse<T> failed() {
        return FnResponse.restResult(null, FAIL, null);
    }

    public static <T> FnResponse<T> failed(String msg) {
        return FnResponse.restResult(null, FAIL, msg);
    }

    public static <T> FnResponse<T> failed(T data) {
        return FnResponse.restResult(data, FAIL, null);
    }

    public static <T> FnResponse<T> failed(T data, String msg) {
        return FnResponse.restResult(data, FAIL, msg);
    }

    public static <T> FnResponse<T> error(Integer code, String msg) {
        return FnResponse.restResult(code, msg);
    }

    private static <T> FnResponse<T> restResult(T data, Integer code, String msg) {
        FnResponse<T> apiResult = new FnResponse<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    private static <T> FnResponse<T> restResult(Integer code, String msg) {
        FnResponse<T> apiResult = new FnResponse<T>();
        apiResult.setCode(code);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public FnResponse() {
    }

    public static <T> FnResponseBuilder<T> builder() {
        return new FnResponseBuilder();
    }

    public String toString() {
        return "FnResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public FnResponse(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static class FnResponseBuilder<T> {
        private int code;
        private String msg;
        private T data;

        FnResponseBuilder() {
        }

        public FnResponseBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public FnResponseBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public FnResponseBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public FnResponse<T> build() {
            return new FnResponse<T>(this.code, this.msg, this.data);
        }

        public String toString() {
            return "FnResponse.FnResponseBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }
}

