package cn.fntop.entity;
import lombok.*;
import org.springframework.http.HttpStatus;

import java.io.Serializable;

/**
 * 响应信息主体
 *
 * @param <T>
 * @author fn
 */
@Builder
@ToString
@Getter
@Setter
@AllArgsConstructor
public class FnResponse<T> {
	protected static final Integer SUCCESS = HttpStatus.OK.value();
	protected static final Integer FAIL = HttpStatus.INTERNAL_SERVER_ERROR.value();
	private static final long serialVersionUID = -5869723792262368348L;
	private int code;
	private String msg;
	private T data;
	public static <T> FnResponse<T> ok() {
		return restResult(null, SUCCESS, null);
	}

	public static <T> FnResponse<T> ok(T data) {
		return restResult(data, SUCCESS, null);
	}

	public static <T> FnResponse<T> ok(T data, String msg) {
		return restResult(data, SUCCESS, msg);
	}

	public static <T> FnResponse<T> failed() {
		return restResult(null, FAIL, null);
	}

	public static <T> FnResponse<T> failed(String msg) {
		return restResult(null, FAIL, msg);
	}

	public static <T> FnResponse<T> failed(T data) {
		return restResult(data, FAIL, null);
	}

	public static <T> FnResponse<T> failed(T data, String msg) {
		return restResult(data, FAIL, msg);
	}
	public static <T> FnResponse<T> error(Integer code, String msg) {
		return restResult(code, msg);
	}
	private static <T> FnResponse<T> restResult(T data, Integer code, String msg) {
		FnResponse<T> apiResult = new FnResponse<>();
		apiResult.setCode(code);
		apiResult.setData(data);
		apiResult.setMsg(msg);
		return apiResult;
	}
	private static <T> FnResponse<T> restResult(Integer code, String msg) {
		FnResponse<T> apiResult = new FnResponse<>();
		apiResult.setCode(code);
		apiResult.setMsg(msg);
		return apiResult;
	}

	public FnResponse() {
		super();
	}

}
