package cn.fntop.config;

import cn.fntop.service.OpenApi;
import cn.fntop.service.OpenApiService;
import cn.fntop.service.OpenApiServiceSubject;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 微信自动配置
 *
 * @author fn
 */
@Configuration
@EnableConfigurationProperties(OpenApiProperties.class)
@RequiredArgsConstructor
public class OpenApiAutoConfiguration {
    private final OpenApiProperties properties;
    @Bean
    public OpenApiService openApiService() {
        return (OpenApiService) OpenApiService.getInstance(properties, OpenApi.class, OpenApiService.class);
    }

}
