package cn.fntop;

import cn.fntop.config.OpenApiProperties;
import cn.fntop.entity.CustomEntity;
import cn.fntop.entity.FnResponse;
import cn.fntop.service.OpenApiService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.*;


/**
 * Hello world!
 */
@SpringBootApplication
@RestController
@RequestMapping("/hello")
@Slf4j
public class OpenApiApplication implements ApplicationContextAware {

    private static OpenApiService openApiService;

    @Autowired
    @GetMapping("/test")
    private FnResponse test() {
        return FnResponse.ok("Hello world! test");
    }

    @PostMapping("/body")
    private FnResponse body(@RequestBody CustomEntity custom) {
        return FnResponse.ok("Hello world! body" + custom.getName());
    }

    public static void main(String[] args) {
        SpringApplication.run(OpenApiApplication.class, args);
        log.info("接口返回信息：\n{}", openApiService.get("hello/test"));
        CustomEntity custom = new CustomEntity();
        custom.setName("这是自定义的请求参数");
        log.info("接口返回信息：\n{}", openApiService.post("hello/body", custom));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        OpenApiApplication.openApiService = applicationContext.getBean(OpenApiService.class);
    }
}
