/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.weixin.Interceptor;

import cn.fntop.weixin.annotation.FnApi;
import cn.fntop.weixin.annotation.FnRestApi;
import cn.fntop.weixin.config.FnConfig;
import cn.fntop.weixin.controller.FnMsgControllerAdapter;
import cn.fntop.weixin.utils.WebUtils;
import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.wxaapp.WxaConfigKit;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class MsgInterceptor
implements AsyncHandlerInterceptor {
    private static final Log logger = LogFactory.getLog(MsgInterceptor.class);
    private final FnConfig config;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class beanType = handlerMethod.getBeanType();
        FnApi fnApi = (FnApi)AnnotationUtils.getAnnotation((AnnotatedElement)beanType, FnApi.class);
        FnRestApi fnRestApi = (FnRestApi)AnnotationUtils.getAnnotation((AnnotatedElement)beanType, FnRestApi.class);
        String appId = request.getParameter(this.config.getAppIdKey());
        if (this.config.getAutoFilter().booleanValue() && this.config.getAppId() != null) {
            appId = this.config.getAppId();
        }
        if (fnApi != null || fnRestApi != null) {
            if (StringUtils.hasText((String)appId)) {
                try {
                    ApiConfigKit.setThreadLocalAppId((String)appId);
                }
                catch (Exception e) {
                    logger.error((Object)"\u60a8\u662f\u5426\u5f00\u542f\u4e86\u81ea\u52a8\u7b5b\u9009\u6a21\u5f0f\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u7b5b\u9009\u6a21\u5f0f\u65f6appId\u662f\u5426\u914d\u7f6e\u6b63\u786e");
                }
            }
            return true;
        }
        Object bean = handlerMethod.getBean();
        boolean isWx = bean instanceof FnMsgControllerAdapter;
        String token = null;
        try {
            if (isWx) {
                if (StringUtils.hasText((String)appId)) {
                    ApiConfigKit.setThreadLocalAppId((String)appId);
                    token = ApiConfigKit.getApiConfig((String)appId).getToken();
                } else {
                    token = ApiConfigKit.getApiConfig().getToken();
                }
            } else if (StringUtils.hasText((String)appId)) {
                WxaConfigKit.setThreadLocalAppId((String)appId);
                token = WxaConfigKit.getWxaConfig((String)appId).getToken();
            } else {
                token = WxaConfigKit.getWxaConfig().getToken();
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u60a8\u662f\u5426\u5f00\u542f\u4e86\u81ea\u52a8\u7b5b\u9009\u6a21\u5f0f\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u7b5b\u9009\u6a21\u5f0f\u65f6appId\u662f\u5426\u914d\u7f6e\u6b63\u786e");
        }
        if (this.isConfigServerRequest(request)) {
            this.configServer(request, response, token);
            return false;
        }
        if (ApiConfigKit.isDevMode()) {
            return true;
        }
        if (this.checkSignature(request, token)) {
            return true;
        }
        WebUtils.renderText(response, "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u5b9a\u662f\u5fae\u4fe1\u670d\u52a1\u5668\u5728\u53d1\u9001\u6d88\u606f\u8fc7\u6765");
        return false;
    }

    private boolean checkSignature(HttpServletRequest request, String token) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        if (StrKit.isBlank((String)signature) || StrKit.isBlank((String)timestamp) || StrKit.isBlank((String)nonce)) {
            logger.error((Object)"check signature failure");
            return false;
        }
        if (this.checkSignature(token, signature, timestamp, nonce)) {
            return true;
        }
        logger.error((Object)("check signature failure:  signature = " + signature + " timestamp = " + timestamp + " nonce = " + nonce));
        return false;
    }

    private boolean isConfigServerRequest(HttpServletRequest request) {
        return StrKit.notBlank((String)request.getParameter("echostr"));
    }

    private void configServer(HttpServletRequest request, HttpServletResponse response, String token) {
        String nonce;
        String timestamp;
        String echostr = request.getParameter("echostr");
        String signature = request.getParameter("signature");
        boolean isOk = this.checkSignature(token, signature, timestamp = request.getParameter("timestamp"), nonce = request.getParameter("nonce"));
        if (isOk && !response.isCommitted()) {
            WebUtils.renderText(response, echostr);
        } else {
            logger.error((Object)"\u9a8c\u8bc1\u5931\u8d25\uff1aconfigServer");
        }
    }

    private boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        Object[] array = new String[]{token, timestamp, nonce};
        Arrays.sort(array);
        String tempStr = (String)array[0] + (String)array[1] + (String)array[2];
        tempStr = HashKit.sha1((String)tempStr);
        return tempStr.equalsIgnoreCase(signature);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ApiConfigKit.removeThreadLocalAppId();
        WxaConfigKit.removeThreadLocalAppId();
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ApiConfigKit.removeThreadLocalAppId();
        WxaConfigKit.removeThreadLocalAppId();
    }

    public MsgInterceptor(FnConfig config) {
        this.config = config;
    }
}

