/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.weixin.cache;

import cn.fntop.weixin.config.FnConfig;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import java.util.Objects;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=1)
public class SpringAccessTokenCache
implements IAccessTokenCache {
    private final FnConfig config;
    private static final String ACCESS_TOKEN_PREFIX = "fn:token:";
    private final CacheManager cacheManager;
    private final FnConfig properties;

    private String getKey() {
        StringBuilder buf = new StringBuilder().append(ACCESS_TOKEN_PREFIX);
        if (this.config.getDevMode().booleanValue()) {
            buf.append("dev");
        }
        return buf.toString();
    }

    public String get(String key) {
        return (String)this.getCache().get((Object)(this.getKey() + key), String.class);
    }

    public void set(String key, String jsonValue) {
        this.getCache().put((Object)(this.getKey() + key), (Object)jsonValue);
    }

    public void remove(String key) {
        this.getCache().evict((Object)(this.getKey() + key));
    }

    private Cache getCache() {
        String accessTokenCacheName = this.properties.getAccessTokenCache();
        Cache cache = this.cacheManager.getCache(accessTokenCacheName);
        return Objects.requireNonNull(cache, "AccessToken cache is null.");
    }

    public SpringAccessTokenCache(FnConfig config, CacheManager cacheManager, FnConfig properties) {
        this.config = config;
        this.cacheManager = cacheManager;
        this.properties = properties;
    }
}

