package cn.fntop.weixin.config;

import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.wxaapp.WxaConfig;
import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * 微信默认yml配置加载器
 *
 * @author fn
 */
@Configuration
@AllArgsConstructor
public class WxConfigDefaultLoader implements WxConfigLoader {

	private final FnConfig config;
	@Override
	public List<ApiConfig> loadWx() {
		// 公众号
		return config.getWxConfigs();
	}

	@Override
	public List<WxaConfig> loadWxa() {
		// 小程序
		return config.getWxaConfigs();
	}
}