/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.penetration.model;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class PenetrateLock<V> {
    private Thread lockThread = Thread.currentThread();
    private CountDownLatch signal = new CountDownLatch(1);
    private boolean success = false;
    private V value = null;
    private String key;

    public PenetrateLock(String key) {
        this.key = key;
    }

    public boolean isCurrent() {
        return this.lockThread == Thread.currentThread();
    }

    public void release() {
        this.signal.countDown();
    }

    public boolean await(Long duration) throws InterruptedException {
        if (null == duration) {
            this.signal.await();
            return true;
        }
        return this.signal.await(duration, TimeUnit.MILLISECONDS);
    }

    public Thread getLockThread() {
        return this.lockThread;
    }

    public CountDownLatch getSignal() {
        return this.signal;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public V getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public void setLockThread(Thread lockThread) {
        this.lockThread = lockThread;
    }

    public void setSignal(CountDownLatch signal) {
        this.signal = signal;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PenetrateLock)) {
            return false;
        }
        PenetrateLock other = (PenetrateLock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Thread this$lockThread = this.getLockThread();
        Thread other$lockThread = other.getLockThread();
        if (this$lockThread == null ? other$lockThread != null : !this$lockThread.equals(other$lockThread)) {
            return false;
        }
        CountDownLatch this$signal = this.getSignal();
        CountDownLatch other$signal = other.getSignal();
        if (this$signal == null ? other$signal != null : !this$signal.equals(other$signal)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PenetrateLock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Thread $lockThread = this.getLockThread();
        result = result * 59 + ($lockThread == null ? 43 : $lockThread.hashCode());
        CountDownLatch $signal = this.getSignal();
        result = result * 59 + ($signal == null ? 43 : $signal.hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "PenetrateLock(lockThread=" + this.getLockThread() + ", signal=" + this.getSignal() + ", success=" + this.isSuccess() + ", value=" + this.getValue() + ", key=" + this.getKey() + ")";
    }
}

