/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.penetration.caffeine;

import cn.flyelf.cache.penetration.PenetrateCache;
import cn.flyelf.cache.penetration.conf.CachePenetrationConfig;
import cn.flyelf.cache.penetration.model.PenetrateLock;
import cn.flyelf.cache.penetration.model.PenetrateLockWrapper;
import cn.flyelf.cache.penetration.model.PenetrateValue;
import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PenetrateCaffeineCache
implements PenetrateCache {
    private static final Logger log = LoggerFactory.getLogger(PenetrateCaffeineCache.class);
    private final CachePenetrationConfig config;
    private final AsyncCache<String, PenetrateValue> cache;
    private final ConcurrentHashMap<String, PenetrateLock<?>> lockers = new ConcurrentHashMap(16);

    public PenetrateCaffeineCache(@Nonnull CachePenetrationConfig config) {
        this.config = config;
        this.cache = this.buildCache();
    }

    @Override
    public Long timeout() {
        return this.config.getPenetrateTimeout();
    }

    @Override
    public long duration() {
        return this.config.getDuration();
    }

    @Override
    public boolean enabled() {
        return this.config.isEnabled();
    }

    @Override
    public <K> void put(K key, Class<?> clazz) {
        this.put(key, clazz, this.duration(), TimeUnit.MILLISECONDS);
    }

    @Override
    public <K> void put(K key, Class<?> clazz, Long duration, TimeUnit timeUnit) {
        PenetrateValue value = new PenetrateValue();
        value.setClazz(clazz);
        value.setDuration(duration);
        value.setTimeUnit(timeUnit);
        CompletableFuture<PenetrateValue> future = CompletableFuture.completedFuture(value);
        String k = clazz.getSimpleName() + key.toString();
        this.cache.put((Object)k, future);
    }

    @Override
    public <K> boolean exist(K key) {
        String k = key.getClass().getSimpleName() + key.toString();
        CompletableFuture future = this.cache.getIfPresent((Object)k);
        return null != future;
    }

    private AsyncCache<String, PenetrateValue> buildCache() {
        return Caffeine.newBuilder().expireAfter((Expiry)new Expiry<String, PenetrateValue>(){

            public long expireAfterCreate(@NonNull String key, @NonNull PenetrateValue value, long currentTime) {
                return value.getTimeUnit().toNanos(value.getDuration());
            }

            public long expireAfterUpdate(@NonNull String key, @NonNull PenetrateValue value, long currentTime, @NonNegative long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(@NonNull String s, @NonNull PenetrateValue penetrateValue, long currentTime, @NonNegative long currentDuration) {
                return currentDuration;
            }
        }).buildAsync();
    }

    @Override
    public <K, V> void getLocker(K key, @Nonnull PenetrateLockWrapper<V> wrapper) {
        wrapper.setOwner(false);
        PenetrateLock locker = this.lockers.computeIfAbsent(key.toString(), k -> {
            PenetrateLock lock = new PenetrateLock((String)k);
            wrapper.setOwner(true);
            return lock;
        });
        wrapper.setLocker(locker);
    }

    @Override
    public <V> void releaseLocker(PenetrateLockWrapper<V> locker) {
        if (null == locker) {
            return;
        }
        if (locker.isOwner() || locker.isCurrent()) {
            locker.release();
            if (locker.isOwner() && null != locker.key()) {
                this.lockers.remove(locker.key());
            }
        }
    }
}

